<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

use Blackbit\PimBundle\lib\Pim\Item\Bmecat\Importer;
use Blackbit\PimBundle\model\Dataport;
use Pimcore\Logger;

function microtime_float()
{
	list($usec, $sec) = explode(" ", microtime());
	return ((float)$usec + (float)$sec);
}

include_once __DIR__ .'/../../../../pimcore/config/startup.php';

@ini_set('memory_limit', -1);
@ini_set('max_execution_time', -1);
@ini_set('max_input_time', -1);

// Error reporting is enabled in CLI
@ini_set('display_errors', 'On');
@ini_set('display_startup_errors', 'On');
error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT);

Pimcore::initConfiguration();
Pimcore::initLogger();

ini_set("max_execution_time", "-1");

Logger::debug('Pim Plugin: Starting import (datasource to rawdata)');

$args = array();
parse_str(implode('&', array_slice($argv, 1)), $args);

$dataportId = (int)$args['dataport'];
$filename = $args['filename'];

$start = microtime_float();

$table = new Dataport();
$dataport = $table->get($dataportId);

if ($dataport) {
	$config = unserialize($dataport['sourceconfig']);
	if (empty($filename)) {
		$filename = $config['file'];
	}
	$js = file_get_contents(implode(DIRECTORY_SEPARATOR, array(__DIR__, '..', 'lib', 'Pim', 'Item', 'libraries.js')));

	$importer = new Importer($dataport, $filename, $js);
	$importer->import();
}

$end = microtime_float();
$duration = ($end - $start);
echo "Dauer: {$duration} Sekunden\n";


Logger::debug('Pim Plugin: Rawdata import finished');
