<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

namespace Blackbit\PimBundle\lib\Pim\Parser;

use Psr\Log\LoggerInterface;

/**
 * Parses CSV-Files according to given configuration
 */
class PimcoreParser implements Parser {
	private $config;
	private $logger;

	public function __construct(array $config, LoggerInterface $logger) {
		$this->config = $config;
		$this->logger = $logger;
	}

	/**
	 * Verarbeitet eine CSV-Datei anhand der übergebenen Konfiguration
	 * @param integer $limit Maximale Anzahl an Einträgen, die zurückgeliefert werden sollen
	 * @return array Aus der Datei ausgelesene Einträge; max $limit, wenn $limit != null
	 */
	public function parse($limit = null) {
        $sourceClassId = $this->config['sourceClass'];
        $classDefinition = \Pimcore\Model\DataObject\ClassDefinition::getById($sourceClassId);

        $listingClass = 'Pimcore\Model\DataObject\\' . ucfirst($classDefinition->getName()) . "\\Listing";

        $listing = \Pimcore::getContainer()->get('pimcore.model.factory')->build($listingClass);
		$listing->setUnpublished(true);
		$listing->setLimit($limit);

        if (empty($this->config['fields'])) {
            $this->logger->error('No field definition given in config');
            return array();
        }

        $items = array();
		foreach($listing as $object) {
            $item = [];
            foreach ($this->config['fields'] as $field => $values) {
                if(!method_exists($object, $values['method'])) {
                    continue;
                }
                $value = call_user_func_array([$object, $values['method']], explode(',', $values['parameters']));
                if($value !== null && !is_scalar($value)) {
                    $value = json_encode($value);
                }
                $item[$field] = $value;
            }

            $items[] = $item;
        }

		return $items;
	}
}
