<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

namespace Blackbit\PimBundle\Command;


use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Blackbit\PimBundle\lib\Pim\RawData;

class ImportRawdataCommand extends AbstractCommand
{
    protected function configure()
    {
        $this
            ->setName('import:rawdata')
            ->setDescription('Imports data from file to database')
            ->addArgument('dataport', InputArgument::REQUIRED, 'Dataport ID to process')
            ->addArgument('filename', InputArgument::OPTIONAL, 'Name of the file to import. Default: File from the dataport config')
            ->addOption('clear-file-after-import', null, InputOption::VALUE_NONE, 'Use this param to remove given file after import.');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        \Pimcore::getEventDispatcher()->dispatch('pim.initRawdataImport');

        $dataportId = $input->getArgument('dataport');
        $filename = $input->getArgument('filename');
        $removeFileAfterImport = $input->getOption('clear-file-after-import');
        
    
        $output->writeln('Starting rawdata import for dataport '. $dataportId);
        if (empty($filename)) {
            $output->writeln('Using default file');
        } else {
            $output->writeln('Using ' . $filename);
        }

        $start = microtime(true);

        $importer = new RawData\Importmanager();

        $importer->setOverrideFile($filename);
        $importer->setRemoveFileAfterImport($removeFileAfterImport);

        $importer->importDataport($dataportId);

        $duration = microtime(true) - $start;

        $output->writeln("Dauer: {$duration} Sekunden");
    }
}