/*
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

pimcore.registerNS("pimcore.plugin.Pim.ImportConfig");

pimcore.plugin.Pim.DataportPreview = Ext.extend(Ext.Panel, {
    dataportId: null,
    grid: null,
    customData: null,
    blocked: false,

    initComponent: function () {
        Ext.apply(this, {
            layout: 'fit'
        });

        this.on('afterrender', this.rebuild.bind(this));
        pimcore.plugin.Pim.DataportPreview.superclass.initComponent.call(this);
    },

    rebuild: function () {
        this.removeAll();

        Ext.Ajax.request({
            url: "/admin/BlackbitPim/importconfig/get-previewgrid-config",
            params: {
                dataportId: this.dataportId
            },
            success: function (response) {
                try {
                    var response = Ext.decode(response.responseText);
                    if (!(response && response.success)) {
                        pimcore.helpers.showNotification(t("error"), t("pim.error_loading_dataport"), "error", t(response.errorMessage));
                    } else {
                        this.addGrid(response.columns);
                    }
                } catch (e) {
                    pimcore.helpers.showNotification(t("error"), t("pim.error_loading_dataport"), "error");
                }
            }.bind(this)
        });
    },

    addGrid: function (columns) {
        var self = this;
        var itemsPerPage = 25;

        var readerFields = [
            {name: 'id'},
            {name: 'inserted'},
            {name: 'updated'}
        ];

        var columnConfig = [
            {
                xtype: 'actioncolumn',
                width: 40,
                sortable: false,
                menuDisabled: true,
                items: [{
                    tooltip: t('pim.delete_rawdata'),
                    icon: "/bundles/pimcoreadmin/img/flat-color-icons/delete.svg",
                    handler: function (grid, rowIndex) {
                        var record = grid.getStore().getAt(rowIndex);

                        Ext.MessageBox.confirm(t('pim.delete_rawdata'), t('pim.delete_rawdata.confirm'), function (btn) {
                            if (btn == 'yes') {
                                Ext.Ajax.request({
                                    url: "/admin/BlackbitPim/importconfig/delete-rawdata",
                                    params: {
                                        id: record.get('id')
                                    },
                                    success: function (response) {
                                        grid.getStore().removeAt(rowIndex);
                                    }.bind(this),
                                    failure: function (response, opts) {
                                        Ext.MessageBox.alert('Fehler', 'Datensatz konnte nicht gelöscht werden');
                                    }.bind(this)
                                });
                            }
                        });
                    }.bind(this)
                }]
            },
            {header: t('pim.dataport_rawitemfield_id'), width: 100, dataIndex: 'id', sortType: 'asInt'},
            {header: t('pim.dataport_rawitemfield_inserted'), width: 120, dataIndex: 'inserted', sortType: 'asDate'},
            {header: t('pim.dataport_rawitemfield_updated'), width: 120, dataIndex: 'updated', sortType: 'asDate'}
        ];

        Ext.each(columns, function (column) {
            readerFields.push({name: 'field_' + column.fieldNo});
            columnConfig.push({
                header: '#' + column.fieldNo + ': ' + column.name,
                dataIndex: 'field_' + column.fieldNo,
                autoSizeColumn: true,
                sortType: 'asUCText',
                convert: function(v, record){
                    return (v === null) ? '' : v
                }
            });
        });

        Ext.define('DataPreviewModel', {
                extend: 'Ext.data.Model',
                fields: ['id', 'name'],
                idProperty: 'id',
                root: 'fields'
            }
        );

        var store = Ext.create('Ext.data.JsonStore', {
            model: 'DataPreviewModel',
            proxy: {
                type: 'ajax',
                url: '/admin/BlackbitPim/importconfig/get-rawdata/' + this.dataportId,
                reader: {
                    type: 'json',
                    rootProperty: 'fields',
                    useSimpleAccessors: false,
                    transform: {
                        fn: function (data) {
                            return data;
                        },
                        scope: this
                    }

                },
                remoteFilter: true,
                filterParam: 'query'
            },

            idProperty: 'id',
            fields: readerFields,
            listeners: {
                totalcountchange: onStoreSizeChange
            },
            remoteFilter: true,
            autoLoad: true
        });


        function onStoreSizeChange() {

            console.log("store.getTotalCount() ", store.getTotalCount());
            //grid.down('#status').update({count: store.getTotalCount()});
        }

        function onPageDataChange(target, p, e) {

            self.blocked = true;
            console.log("onPageDataChange ", target, p, e);
            //grid.down('#status').update({count: store.getTotalCount()});
        }


        var toolbar = Ext.create('Ext.toolbar.Paging', {
            pageSize: 25,
            store: store,
            displayInfo: true,
            displayMsg: '{0} - {1} / {2}',
            emptyMsg: t("no_objects_found"),
            mode: "local"
        });

        toolbar.add("-");
        toolbar.add(new Ext.Toolbar.TextItem({text: t("items_per_page")}));
        toolbar.add(new Ext.form.ComboBox({
            store: [
                [25, "25"],
                [50, "50"],
                [100, "100"],
                [200, "200"],
                [999999, t("all")]
            ],
            mode: "local",
            width: 50,
            value: toolbar.pageSize,
            triggerAction: "all",
            listeners: {
                select: function (box, rec, index) {
                    itemsPerPage = intval(rec.data.field1);
                    store.pageSize = itemsPerPage;
                    toolbar.pageSize = itemsPerPage; //intval(rec.data.field1);
                    toolbar.moveFirst();

                    console.log("itemsPerPage ", itemsPerPage, rec, rec.data.field1);
                }.bind(this)
            }
        }));


        var searchField = Ext.create('Ext.ux.form.SearchField', {
            width: 400,
            fieldLabel: 'Schnellsuche',
            labelWidth: 80,
            xtype: 'searchfield',
            store: store
        });


        this.grid = new Ext.grid.Panel({
            border: false,
            frame: false,
            autoScroll: true,
            store: store,
            columnLines: true,
            stripeRows: true,
            multiColumnSort: true,
            columns: columnConfig,

            dockedItems: [{
                dock: 'top',
                xtype: 'toolbar',
                items: [
                    searchField,
                    '->',
                    {
                        xtype: 'button',
                        text: 'Rohdaten leeren',
                        iconCls: 'pimcore_icon_delete',
                        listeners: {
                            'click': function () {
                                Ext.MessageBox.confirm('Rohdaten leeren', 'Sollen alle Rohdaten dieses Datenports gelöscht werden?', function (btn) {
                                    if (btn === 'yes') {
                                        Ext.Ajax.request({
                                            url: "/admin/BlackbitPim/import/delete-rawdata",
                                            params: {
                                                dataportId: self.dataportId
                                            },

                                            success: function(response, opts) {
                                                var obj = Ext.decode(response.responseText);
                                                if (obj.success) {
                                                    self.grid.getStore().load();
                                                } else {
                                                    Ext.MessageBox.alert('Fehler', 'Beim Löschen der Rohdaten ist ein Fehler aufgetreten.');
                                                }
                                            },

                                            failure: function(response, opts) {
                                                Ext.MessageBox.alert('Fehler', 'Beim Löschen der Rohdaten ist ein Fehler aufgetreten.');
                                            }
                                        });
                                    }
                                });
                            }
                        }
                    }
                    /*{
                        xtype: 'component',
                        itemId: 'status',
                        tpl: 'Matching threads: {count}',
                        style: 'margin-right:5px'
                    }*/
                ]
            }],
            bbar: toolbar,

            listeners: {
                afterrender: function (grid) {
                    grid.getStore().load();
                },
                render: function(grid, eOpts) {
                    var headerContainer = grid.getHeaderContainer();
                    headerContainer.on('menucreate', function(container, menu, eOpts) {
                        var sibling, index;
                        // if we allow multi sorting and this column is sortable
                        if (grid.multiColumnSort && container.sortable) {
                            sibling = menu.down('#descItem');
                            index = menu.items.indexOf(sibling);
                            menu.insert(index + 1, {
                                itemId: 'removeSortItem',
                                text: 'Remove Sort',
                                iconCls: 'delete-icon',
                                handler: 'onRemoveSortClick',
                                scope: grid
                            })
                        }
                    });
                }
            },
            onRemoveSortClick: function(button, e, eOpts) {
                var store = this.getStore(),
                    headerContainer = this.getHeaderContainer(),
                    column = headerContainer.getMenu().activeHeader,
                    sorters = store.getSorters(),
                    columns = this.getColumns();
                // remove from sorters
                sorters.removeByKey(column.dataIndex);
                // update sort state
                column.sortState = null;
                column.removeCls([column.ascSortCls, column.descSortCls]);
            },
            viewConfig: {
                listeners: {
                    refresh: function(dataview) {
                        Ext.each(dataview.panel.columns, function(column) {
                            if (column.autoSizeColumn === true) {
                                column.autoSize();
                            }
                        })
                    }
                }
            }
        });

        this.add(this.grid);
        pimcore.layout.refresh();
    }
});