/*
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

pimcore.registerNS("pimcore.plugin.Pim.plugin");

pimcore.plugin.Pim.plugin = Class.create(pimcore.plugin.admin, {

    getClassName: function () {
        return "pimcore.plugin.Pim.plugin";
    },

    initialize: function () {
        pimcore.plugin.broker.registerPlugin(this);

        if(typeof pimcore.helpers.addCsrfTokenToUrl === 'undefined') {
            pimcore.helpers.addCsrfTokenToUrl = function (url) {

                // only for /admin urls
                if(url.indexOf('/admin') !== 0) {
                    return url;
                }

                if (url.indexOf('?') === -1) {
                    url = url + "?";
                } else {
                    url = url + "&";
                }
                url = url + 'csrfToken=' + pimcore.settings['csrfToken'];

                return url;
            };
        }
    },

    uninstall: function () {
        //TODO remove from menu
    },

    pimcoreReady: function (params, broker) {
        var user = pimcore.globalmanager.get("user");

        if (!user.isAllowed('plugin_bb_pim')) {
            return;
        }

        // create a toolbar
        var toolbar = pimcore.globalmanager.get("layout_toolbar");


        var importConfigID = "action_pim_importconfig";

        var importConfigItem = {
            text: t("pim.Imports"),
            iconCls: "pimcore_icon_settings",
            handler: function () {
                try {
                    pimcore.globalmanager.get(importConfigID).activate();
                }
                catch (e) {
                    pimcore.globalmanager.add(importConfigID, new pimcore.plugin.Pim.ImportConfig(importConfigID));

                }
            }
        };


        var mappingID = "action_pim_mappingconfig";

        var mappingItem = {
            text: t("pim.mapping_config"),
            iconCls: "pimcore_icon_settings",
            handler: function () {
                try {
                    pimcore.globalmanager.get(mappingID).activate();
                }
                catch (e) {
                    pimcore.globalmanager.add(mappingID, new pimcore.plugin.Pim.MappingConfig(mappingID));

                }
            }
        };


        var pimMenuID = "txtmenu_pim_config";

        var pimMenuItem = {
            id: "txtmenu_pim_config",
            text: t("pim.PIM config"),
            iconCls: "pimcore_icon_settings",
            hideOnClick: false,
            menu: [importConfigItem, mappingItem]
            //menu: [importConfigItem]
        };

        toolbar.settingsMenu.add(pimMenuItem);


        // Models
        Ext.define('MappingConfigModel', {
            extend: 'Ext.data.Model',
            idProperty: 'attributeKey',

            fields: [
                {
                    name: 'attributeName',
                    type: 'string'
                },
                {
                    name: 'type',
                    type: 'auto'
                },
                {
                    name: 'field',
                    type: 'auto'
                },
                {
                    name: 'settings',
                    type: 'auto'
                },
                {
                    name: 'localized',
                    type: 'auto'
                },
                {
                    name: 'localized',
                    type: 'auto'
                }

            ]
        });

        Ext.define('DataPortModel', {
                extend: 'Ext.data.Model',
                fields: ['id', 'name'],
                idProperty: 'id',
                root: 'fields'
            }
        );

        Ext.define('JavascriptEngineModel', {
                extend: 'Ext.data.Model',
                fields: ['id', 'available'],
                idProperty: 'id',
                root: 'data'
            }
        );

        Ext.define('MappingDataPortModel', {
            extend: 'Ext.data.Model',
            fields: [
                // Person fields
                {name: 'index', type: 'int', defaultValue: -1, persist: true},
                {name: 'id', type: 'string'},
                {name: 'name', type: 'string'},
                {name: 'iconCls', type: 'string', defaultValue: 'pimcore_icon_class'},
                {name: 'expandable', type: 'bool', defaultValue: false, persist: true, convert: null},
                {name: 'allowDrop', type: 'boolean', defaultValue: false, persist: false, convert: null}
                //TODO ADD Reference & Listeners
                //     listeners: this.getTreeNodeListeners(),
                // reference: this,
            ],
            proxy: {
                type: 'ajax',
                api: {
                    create: 'createDataUrl',
                    read: '/admin/BlackbitPim/mappingconfig/get-dataports',
                    update: 'updateDataUrl',
                    destroy: 'destroyDataUrl'
                }
            }
        });

        Ext.define('ImportDataPortModel', {
            extend: 'Ext.data.Model',
            fields: [
                // Person fields
                {name: 'index', type: 'int', defaultValue: -1, persist: true},
                {name: 'id', type: 'string'},
                {name: 'name', type: 'string'},
                {name: 'iconCls', type: 'string', defaultValue: 'pimcore_icon_class'},
                {name: 'expandable', type: 'bool', defaultValue: false, persist: true, convert: null},
                {name: 'allowDrop', type: 'boolean', defaultValue: false, persist: false, convert: null}
                //TODO ADD Reference & Listeners
                //     listeners: this.getTreeNodeListeners(),
                // reference: this,
            ],
            proxy: {
                type: 'ajax',
                api: {
                    create: 'createDataUrl',
                    read: '/admin/BlackbitPim/importconfig/get-dataports',
                    update: 'updateDataUrl',
                    destroy: 'destroyDataUrl'
                }
            }
        });

    }
});

var pim = new pimcore.plugin.Pim.plugin();