/*
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

pimcore.registerNS("Pim.importConfig");
Pim.CheckPanel = Ext.extend(Ext.Panel, {
	status: null,

	msg: null,
	fileInfo: {},
	button: null,

	initComponent: function() {
		var self = this;

		this.msg = new Ext.Panel({
			border: false,
			tpl: new Ext.XTemplate(
				'<div class="bb_pim_content">',
					'<h1>{msg}</h1><br>',
					'<tpl if="fileInfo">',
						'<table border="0">',
							'<tr><th></th><th class="colspacer"></th><th colspan="3" class="headline">Vergleich zum letzten Import</th></tr>',
							'<tr><td colspan="5"></td></tr>',
							'<tr><th></th><td></td><th class="headline infocol">Kategorien</th><th class="headline infocol">Produkte</th><th class="headline infocol">Features</th></tr>',
							'<tr><td><span class="notification_label">Anzahl Kategorien:</span> {[values.fileInfo.categories]}</td><td></td><td><span class="notification_label_short">Neu:</span> {[values.comparison.categories.new.length]}</td><td><span class="notification_label_short">Neu:</span> {[values.comparison.products.new.length]}</td><td><span class="notification_label_short">Neu:</span> {[values.comparison.features.new.length]}</td></tr>',
							'<tr><td><span class="notification_label">Anzahl Produkte:</span> {[values.fileInfo.products]}</td><td></td><td><span class="notification_label_short">Entfernt:</span> {[values.comparison.categories.missing.length]}</td><td><span class="notification_label_short">Entfernt:</span> {[values.comparison.products.missing.length]}</td><td><span class="notification_label_short">Entfernt:</span> {[values.comparison.features.missing.length]}</td></tr>',
							'<tr><td><span class="notification_label">Anzahl Features:</span> {[values.fileInfo.attributes]}</td><td></td><td><span class="notification_label_short">Geändert:</span> {[values.comparison.categories.changed.length]}</td><td><span class="notification_label_short">Geändert:</span> {[values.comparison.products.changed.length]}</td><td></td></tr>',
							'<tr><td><span class="notification_label">Anzahl Bilder:</span> {[values.fileInfo.assetImage]}</td><td></td><td colspan="3"></td></tr>',
							'<tr><td><span class="notification_label">Anzahl PDFs:</span> {[values.fileInfo.assetPdf]}</td><td></td><td colspan="3"></td></tr>',
							'<tr><td><span class="notification_label">Anzahl anderer Assets:</span> {[values.fileInfo.assetOther]}</td><td></td><td colspan="3"></td></tr>',
						'</table>',
					'</tpl>',
				'</div>'
			)
		});

		this.button = new Ext.Button({
			hidden: true,
			text: t('pim.dataport.bmecat.toConfigButton'),
			handler: function() {
				if (Ext.isFunction(this.importAction)) {
					this.importAction(self.status.comparison);
				}
			}.bind(this)
		});

		Ext.apply(this, {
			border: false,
			hidden: true,
			padding: 10,
			/*
			layout: {
				type: 'vbox',
				flex: '1',
				padding: 5,
				align: 'stretch'
			},
			*/
			listeners: {
				'afterrender': function() {
					this.refresh();
				}.bind(this)
			},
			items: [this.msg, {xtype: 'spacer', height: 50}, this.button]
		});

		Pim.CheckPanel.superclass.initComponent.call(this);
	},

	setStatus: function(status) {
		this.status = status;
		this.refresh();
	},

	refresh: function() {
		if (this.status) {
			this.setVisible(true);
			if (this.status.isValid === true) {
				this.msg.update({
					msg: t('pim.dataport.bmecat.filestatus.valid'),
					fileInfo: this.status.fileInfo,
					comparison: this.status.comparison
				});
				this.button.setVisible(true);
			} else {
				this.msg.update({
					msg: t('pim.dataport.bmecat.filestatus.invalid'),
					fileInfo: null
				});
			}
		} else {
			this.setVisible(false);
		}

		pimcore.layout.refresh();
	}
});