<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

namespace Blackbit\PimBundle\lib\Pim\Shop;
/**
 * Interface für Klassen zur Shop-Preisberechnung
 *
 * @author Dennis Korbginski <dennis.korbginski@blackbit.de>
 * @copyright Blackbit neue Medien GmbH, http://www.blackbit.de/
 */
interface Pricecalculator {
	/**
	 * Berechnet den Nettopreis eines Artikels
	 * @param $item mixed Der Artikel
	 * @param $amount float Menge. Kann eine Dezimalzahl sein, z.B. ein Gewicht
	 * @param array $options zusätzliche Optionen zur Preisberechnung
	 * @return float Preis
	 */
	public function calculateNetPrice($item, $amount, $options = array());

	/**
	 * Berechnet die Steuern, die auf den Artikel entfallen
	 * @param $item mixed Der Artikel
	 * @param $amount float Menge. Kann eine Dezimalzahl sein, z.B. ein Gewicht
	 * @param array $options zusätzliche Optionen zur Preisberechnung
	 * @return float Steuern
	 */
	public function calculateVatPrice($item, $amount, $options = array());
}
