<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Blackbit\PimBundle\model;

/**
 * Class ResourceFactory
 *
 * @package Blackbit\PimBundle\model
 */
class ResourceFactory
{
    /**
     * @var array
     */
    protected $resources = [];

    /**
     * @return Variant
     */
    public function variant()
    {
        if (!isset($this->resources[__FUNCTION__])) {
            $this->resources[__FUNCTION__] = new Variant();
        }

        return $this->resources[__FUNCTION__];
    }

    /**
     * @return VariantItemField
     */
    public function variantItemField()
    {
        if (!isset($this->resources[__FUNCTION__])) {
            $this->resources[__FUNCTION__] = new VariantItemField();
        }

        return $this->resources[__FUNCTION__];
    }

    /**
     * @return VariantGenerator
     */
    public function variantGenerator()
    {
        if (!isset($this->resources[__FUNCTION__])) {
            $this->resources[__FUNCTION__] = new VariantGenerator();
        }

        return $this->resources[__FUNCTION__];
    }

    /**
     * @return RawItem
     */
    public function rawItem()
    {
        if (!isset($this->resources[__FUNCTION__])) {
            $this->resources[__FUNCTION__] = new RawItem();
        }

        return $this->resources[__FUNCTION__];
    }

    /**
     * @return RawItemField
     */
    public function rawItemField()
    {
        if (!isset($this->resources[__FUNCTION__])) {
            $this->resources[__FUNCTION__] = new RawItemField();
        }

        return $this->resources[__FUNCTION__];
    }

    /**
     * @return Fieldmapping
     */
    public function fieldMapping()
    {
        if (!isset($this->resources[__FUNCTION__])) {
            $this->resources[__FUNCTION__] = new Fieldmapping();
        }

        return $this->resources[__FUNCTION__];
    }

    /**
     * @return Dataport
     */
    public function dataport()
    {
        if (!isset($this->resources[__FUNCTION__])) {
            $this->resources[__FUNCTION__] = new Dataport();
        }

        return $this->resources[__FUNCTION__];
    }
}
