# Blackbit Pim Import
Map data from CSV, XML, Excel and BMEcat sources to Pimcore objects and their attributes.
For a quick overview how to use this plugin, see the [video for CSV/XML](https://youtu.be/hAdgJPA8z2Q) and the [video for BMEcat](https://youtu.be/b5kWyKBWwok) import configuration.

## Requirements
The plugin works with Pimcore out of the box without any special requirements. If you want to modify data via JavaScript while importing, you need to have the PECL extension [v8js](https://pecl.php.net/package/v8js) (recommended) or [spidermonkey](https://pecl.php.net/package/spidermonkey) installed.

## Installation
### Composer
You need a BitBucket account to access our repository via composer. Please send us the email address of your BitBucket account so we can allow access to the repository.

When we allow your account to access our repository, please add the repository to your composer.json (see https://getcomposer.org/doc/05-repositories.md#vcs):
```json
"repositories": [
        {
            "type": "vcs",
            "url": "https://bitbucket.org/blackbitwerbung/pimcore-plugins-pim"
        }
    ],
```

And then you should be able to execute `composer require blackbit/pim:dev-master` from CLI.

At last you have to enable and install the plugin, either via browser UI or via CLI `bin/console pimcore:bundle:enable BlackbitPimBundle && bin/console pimcore:bundle:install BlackbitPimBundle`
 
You can always access the latest version by executing „composer update blackbit/pim“ on CLI.

### Manual installation
If you have a BitBucket account which got allowed to access the plugin repository, you can always download the current version of this plugin at https://bitbucket.org/blackbitwerbung/pimcore-plugins-pim/get/HEAD.zip

Otherwise you have received the plugin as zip file (e.g. via email).

Unzip the zip file to src/blackbit/PimBundle. 
Then you have to enable and install the plugin, either via browser UI or via CLI `bin/console pimcore:bundle:enable BlackbitPimBundle && bin/console pimcore:bundle:install BlackbitPimBundle`

## Quick overview
Importing will run in two phases:
1. Parse source file, import data into a flat database table
2. Map data from table to object attributes. Modify the data along the way if necessary.

Each data source can be configured as a "data port" in the UI.

No transformation of data will occur in the first phase. This is purely a step to see if you configured your data parsing expressions correctly.

The second step tries to transform the data to the expected data type, for example find related objects, parse numbers and dates.
For some data types, this parsing can be configured via the settings button ![Settings button](http://www.dustball.com/icons/icons/page_white_gear.png) in the mapping grid. Numbers, for example, require you to specify decimal and thousands separators.

You also have to set a key attribute for one mapped field which will be used in future imports to find existing objects to be updated.

### Migrations
From version to version we extend the Bundle continually. So there will be some modifications on the database scheme and you have to perform migrations after updating this plugin. Use the following command to apply these database changes:
```
# Check the status of migration
bin/console pimcore:migration:status -b BlackbitPimBundle

# Run migration process to apply all database changes since the last migration run
bin/console pimcore:migration:migrate -b BlackbitPimBundle
```

## Importing data to objects
Start the import either in the UI as shown in the video, or via CLI by executing these scripts: 
- `bin/console import:rawdata <Dataport-ID> [--clear-file-after-import]` - Parse source file and write data a flat database table (replace <Dataport-ID> with the real ID).
If `--clear-file-after-import` the imported file will get deleted after raw data import
- `bin/console import:pim <Dataport-ID> [Rawdata-ID] [--ignore-hash-check]` - Maps raw data to pimcore objects and attributes, updates exiting objects or created new ones as needed. If `--ignore-hash-check` is set, there won't be a check if certain raw data already got imported to a certain data object.
To see all parameters and a description of these commands you can use `bin/console import:rawdata --help` or `bin/console import:pim --help`.

### Importing data from folders
You can specify a folder path instead of a single file. In this case files in this folder (and subfolders) are imported subsequently. Already imported files are stored in the archive folder whithin the import folder.

### Importing data from URLs
You can specify a URL instead of a file.

### Importing data from Pimcore data objects
Sometimes Pimcore's built-in mass-data editing is not suitable for certain requirements:
 * due to max execution time you can only edit a certain number of objects at the same time
 * when you want dynamic values depending on another object field
 * data of some field types cannot be edited in grid view
In these cases you can choose "Pimcore" as data source to import data from Pimcore data objects. After choosing a source class all methods starting with "get" are provided as raw data fields. You can extend this list by [overriding the data model class](https://pimcore.com/docs/5.x/Development_Documentation/Extending_Pimcore/Overriding_Models.html).

Another use-case for this feature is when you want to change a data type of a class / brick / field collection field without losing existing data. You can first import existing data as raw data, then change the class / brick / field and thereafter reimport the data to the new field.

## Define order of import

When importing data to data objects (`import:pim`) the order of raw data fields defines the order of the data import. At first the raw data item with the "lowest" value in the uppermost field gets imported. If multiple row data items have the same value in the uppermost field, then the import order is defined by the second field, etc. - just like SQL's `ORDER BY column1, column2` feature. This is especially useful if raw data items of one import depend on each other (e.g. master slave data - you have to import masters first to get correct hierarchy).

## Modifying data via callback functions
In the settings dialog for each field in the mapping grid, you can specify a callback function to modify the data that will be written to the object attribute. 

The language of the callback function code depends on your choice in the dataport setting `Callback function interpreter`.
For V8 and the Spidermonkey function wrapper you have to use JavaScript code. For PHP it is PHP.
You only have to enter the function body in the "formula" field. All parameters passed to the function will be properties of the ```params``` object.

Example JavaScript code:
```javascript
var value = params.value;

// Conditionally add some taxes to a price
if (params.rawItemData['field_4'].value == 'something') {
    value = value * 1.07;
}

return value;
```

Example PHP code:
```PHP
$value = $params['value'];

// Conditionally add some taxes to a price
if (params['rawItemData']['field_4']['value'] == 'something') {
    $value = $value * 1.07;
}

return $value;
```

For convenience, [underscore.js](http://underscorejs.org/) and [underscore.string](https://epeli.github.io/underscore.string/) are injected into the code in version 1.4.4 and 2.3.0 respectively for JS interpreters.
            
With the legacy Spidermonkey implementation, after it evaluates the code, it will return the value of the last expression used in your code back to PHP.
That means: do not use an explicit return statement. Instead, just omit the return keyword.
```javascript
// Conditionally add some taxes to a price
if (rawItemData['field_4'].value == 'something') {
    value = value * 1.07;
}

// Omit the "return" here
value;
```

**We highly recommend using V8 or PHP** instead of Spidermonkey.

### Data passed into the callback function as argument (properties of the `params` object)
- `value` - The raw data value as imported from the source file
- `currentValue` - The attribute value currently set in the object
- `rawItemData` - Array with all raw data values for this item. Access data by field index as specified in the data parsing configuration or by raw data field name, e.g.: `rawItemData['field_1']` or `rawItemData['name']`
- `currentObjectData` - Array with all current values from the object. Access data by field name from the class definition like so: `currentObjectData['price']`

## Skipping items
You can skip items by returning `null` in the callback function for the set key column.

## Non-scalar field types

### Object relation
To assign objects based on raw data it is necessary to provide some information how to find these objects. In addition to the raw data field value Pimcore needs to know of which class the desired object is and which field to use for querying, example:

`return 'ClassName:fieldName:'+params.value;`

This code tries to find an object of class "ClassName" which has fieldName = imported raw data field.

### Object relation with metadata
The definition how to find the object to be assigned works the same as with normal object relation with the only difference that the return value has to be a JS object with the object querying string in the field `query`. Other meta columns can be set via key-value pairs within this JS object.
Example:

```javascript
return [
  {
    'query': 'Person:email:'+params.value,
    'metaDataFieldName': params.rawItemData['rawDataColumn'].value
  }
];
```

This adds a relation to an object of class `Person` which has the given raw data value in its field `email`. Additionally the metadata column `metaDataFieldName` is set to the value of raw data column `rawDataColumn`.


### Asset relation
To assign an asset to an image, multihref etc. field you have to provide a URL under which the asset is accessible. The importer tries to load the given URL and imports the asset to the target folder (configurable under dataport settings).

For image fields::
```javascript
return 'https://example.org/'+params.rawItemData['imageUrl'].value;

// or

return {
    'url': 'https://example.org/'+params.rawItemData['imageUrl'].value,
    'filename': params.rawItemData['name'].value
};
``` 

For Multihref fields applies the same format as for image fields but you can provide multiple entries:
```javascript
return [
    'https://example.org/'+params.rawItemData['imageUrl_1'].value
    'https://example.org/'+params.rawItemData['imageUrl_2'].value
];

// or

return [
    {
        'url': 'https://example.org/'+params.rawItemData['imageUrl_1'].value,
        'filename': params.rawItemData['name'].value+'_1'
    },
    {
        'url': 'https://example.org/'+params.rawItemData['imageUrl_2'].value,
        'filename': params.rawItemData['name'].value+'_2'
    }
];
```

### Asset relation with metadata
To assign an asset together with some metadata you have to return an array of JS objects. The asset URL has to be in field `url` of this object. Other metadata fields can be set with key-value pairs in the JS object. Example:

```javascript
return [
  {	
    "url": params.rawItemData['image-url-field'].value,
    "metaField1": "ABC",
    "metaField2": params.rawItemData['rawDataColumn'].value
  }
];
```

If you want to change the filename of the asset which gets created by the import you can use th field `filename`.

### Quantity values
To fill a quantity value field you have to return an array with the JS callback function. The first array item is the value, the second the unit abbreviation, for example:

`return [params.value,'mm'];`

### Field collections
Field collection values can be assigned by providing a JSON array with objects whose keys represent the fields of the field collection, for example:

```javascript
return [
{
  "field1": params.rawItemData['field_1'].value,
  "field2": params.rawItemData['field_2'].value
},
{
  "field1": params.rawItemData['field_3'].value,
  "field2": params.rawItemData['field_4'].value
}
];
```
The importer tries every field collection which is allowed in the target class field. If it encounters a field returned by the JS function which does not exist in the field collection it continues with the next field collection.

#### Localized fields within field collection
```javascript
return [
  {
    "field1": params.rawItemData['field_1'],
    "field2": params.rawItemData['field_2'],
    "field3_localized": [
       [params.rawItemData['Text_DE'].value, 'de'],
       [params.rawItemData['Text_EN'].value, 'en']
    ]
  }
]
```

#### Asset relation within field collection
```javascript
return [
  {
    "asset_field": [
        [
            {
                "query": "Image:path:/path/to/image/"+params.value
            }
        ]
    ]
  }
]
```

#### Asset / object relation in localized field in field collection
```javascript
return [
  {
    "asset_field": [
        [
            {
                "query": "Image:path:/path/to/image/"+params.value
            }, 'de'
        ],
        [
            {
                "query": "Image:path:/path/to//other/image/"+params.value
            }, 'en'
        ]
    ]
  }
]
```


### Object bricks
Object bricks can be added with a JSON object. Object keys are the brick names.

```javascript
return {
    'brickName1': {
        "field1": params.rawItemData['field_1'].value,
        "field2": params.rawItemData['field_2'].value
    },
    'brickName2': {
        "field1": params.rawItemData['field_1'].value,
        "field2": params.rawItemData['field_2'].value
    }
};
```
`field1` and `field2` refer to the field names within the brick.



### Object's publication state
On the dataport panel you can set the state (published / unpublished) of objects after import. There are 3 possibilities:
* `return 1;` publishes objects after import
* `return 0;` unpublishes objects after import
* `return params.currentStatus;` keeps state as it was before the import

# Troubleshooting
## Import does not update my data objects
If you once imported data to a data object a property with the hash of all belonging raw data gets added to the object. On the next import it will be checked if the object which got found via the set key attributes already has this hash attribute and it is equal to the current raw data to be imported. If it is no data gets updated to not accidentally overwrite manual changes to fields which got initially filled ba the import.
To bypass this behaviour you can use the option `--ignore-hash-check` when doing the "import:pim" step, e.g.
`bin/console import:pim --ignore-hash-check <Dataport-ID>`

# License
Copyright (c) Blackbit neue Werbung neue Medien GmbH

This program may be used free of charge by pimcore partners and their customers only.
Everyone else requires a paid license. 

# Third-party libraries and software
This product makes use of modified and unmodified icons from the "Silk" icon set from http://www.famfamfam.com/lab/icons/silk/

# Demo in Docker
To run the demo you need to run `docker-compose up -d` to start the container. After that you have to login to the container via `docker exec -it pim_web_1 /bin/bash`. After Pimcore got downloaded (`ps aux|grep /run.sh` returns empty string), you can link the Pim plugin directory to Pimcore via `cp -R /var/src/BlackbitPimBundle /var/www/src && chown -R www-data:www-data /var/www/src/BlackbitPimBundle/`.

You can then access the demo under `localhost:8080/install.php`.
* DB-User: project_user
* DB-Password: secretpassword
* DB-Name: project_database

# Database update to prevent recreation of deleted objects

In old versions there was a problem when the Pim object got deleted while the imported raw data was still present. We fixed this but the database needs to be altered by the following SQL statements:
```SQL
ALTER TABLE plugin_pim_rawitem_item DROP FOREIGN KEY plugin_pim_rawitem_item_ibfk_2;
ALTER TABLE plugin_pim_rawitem_item DROP FOREIGN KEY plugin_pim_rawitem_item_ibfk_1;
ALTER TABLE plugin_pim_rawitem_item DROP PRIMARY KEY;
ALTER TABLE plugin_pim_rawitem_item ADD id int(11) UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT FIRST;
ALTER TABLE plugin_pim_rawitem_item CHANGE itemId `itemId` int(11) UNSIGNED NULL;
ALTER TABLE plugin_pim_rawitem_item ADD UNIQUE (rawItemId, itemId);
ALTER TABLE plugin_pim_rawitem_item ADD CONSTRAINT FOREIGN KEY (`itemId`) REFERENCES `objects` (`o_id`) ON DELETE SET NULL ON UPDATE CASCADE;
ALTER TABLE plugin_pim_rawitem_item ADD CONSTRAINT FOREIGN KEY (`rawItemId`) REFERENCES `plugin_pim_rawitem` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;
```