/*
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

pimcore.registerNS("pimcore.plugin.Pim.ImportConfig");
pimcore.plugin.Pim.BmecatImport = Ext.extend(Ext.Panel, {
	dataportId: null,

	stepUpload: null,
	stepConfig: null,

	importForm: null,
	formPanel: null,
	checkResult: null,

	configPanel: null,

	initComponent: function() {
		var self = this;

		this.importForm = new Ext.form.FormPanel({
			border: false,
			fileUpload: true,
			labelWidth: 50,
			bodyStyle: 'padding: 10px 10px 0 10px;',
			defaults: {
				anchor: '97%',
				allowBlank: true,
				msgTarget: 'side'
			},
			items: [{
				xtype: 'fileuploadfield',
				emptyText: t('pim.manual.importForm.emptyUpload'),
				fieldLabel: t('pim.manual.importForm.uploadLabel'),
				name: 'importfile',
				buttonText: '',
				buttonCfg: {
					iconCls: 'pimcore_icon_file'
				}
			}, {
				xtype: 'hidden',
				name: 'dataportId',
				value: this.dataportId
			}],
			buttons: [{
				text: t('pim.dataport.bmecat.uploadButton'),
				handler: function() {
					if(this.importForm.getForm().isValid()) {
						this.importForm.getForm().submit({
							url: pimcore.helpers.addCsrfTokenToUrl('/admin/BlackbitPim/import/upload-bmecat'),
							waitMsg: t('pim.dataport.bmecat.waitMsg'),
							success: function(fp, action){
								this.checkResult.setStatus(action.result);
							}.bind(this),
							failure: function(form, action) {

								var msg = '';
								if (action.result.msg) {
									msg = '<br>' + t(action.result.msg);
								}

								Ext.MessageBox.alert(t('error'), t('pim.manual.importForm.failure') + msg);
							}.bind(this)
						});
					}
				}.bind(this)
			}]
		});

		this.checkResult = new Pim.CheckPanel({
			importAction: function(comparisonResult) {
//				self.stepUpload.hide();
//				self.stepConfig.show();

				self.removeAll();
				self.add({
					xtype: 'container',
					layout: 'fit',
					items: [self.stepConfig]
				});
				self.stepConfig.load(self.dataportId, comparisonResult);

				self.updateLayout();
				pimcore.layout.refresh();
			}
		});

		this.stepUpload = new Ext.Panel({
			border: false,
//			layout: {
//				type: 'vbox',
//				flex: 1,
//				padding: 5,
//				align: 'stretch'
//			},
			items: [this.importForm, this.checkResult]
		});

		this.stepConfig = new Pim.ConfigPanel();

		Ext.apply(this, {
			border: false,
			title: t('pim.dataport.bmecat.configpanel.title'),
			closable: true,
			layout: 'fit',
			/*
			layout: {
				type: 'vbox',
				flex: 1,
				padding: 5,
				align: 'stretch'
			},
			*/
			listeners: {
				'afterrender': function() {

				}
			},
			items: [this.stepUpload]
		});

		Pim.BmecatImport.superclass.initComponent.call(this);

		// show the panels by refreshing
		pimcore.layout.refresh();
	}
});