/*
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

pimcore.registerNS("pimcore.plugin.Pim.ImportConfig");
pimcore.plugin.Pim.ManualImport = Ext.extend(Ext.Panel, {
    dataportId: null,

    importForm: null,
    formWindow: null,
    statusGrid: null,

    refreshActive: false,

    initComponent: function () {

        Ext.apply(this, {

            html: 'Floating Panel',
            left: 0,
            padding: 10,

            xtype: 'panel',
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'top',   // the component will dock to the 'top' unless specified
                items: [
                    {
                        text: t('pim.manual.startimport.rawdata'),
                        iconCls: 'pimcore_icon_add',
                        handler: function (b, e) {
                            if (this.formWindow && this.importForm) {
                                this.importForm.getForm().findField('importType').setValue('raw');
                                this.importForm.getForm().findField('importfile').reset();
                                this.formWindow.show();
                            }
                        }.bind(this)
                    }, '|', {
                        text: t('pim.manual.startimport.pim'),
                        iconCls: 'pimcore_icon_add',
                        handler: function (b, e) {
                            Ext.Msg.show({
                                title: t('pim.manual.startimport.pim.title'),
                                msg: t('pim.manual.startimport.pim.text')+'<br/><br/><label><input type="checkbox" id="ignore-hash-check" checked /> '+t('pim.manual.startimport.pim.ignore-hash-check')+'</label>',
                                buttons: Ext.Msg.YESNO,
                                fn: function (btn) {
                                    if (btn == 'yes') {
                                        // Basic request
                                        Ext.Ajax.request({
                                            url: '/admin/BlackbitPim/import/manual-pim-import',
                                            success: function (response) {
                                                try {
                                                    response = Ext.decode(response.responseText);
                                                    if (!(response && response.success)) {
                                                        pimcore.helpers.showNotification(t("error"), t("pim.error_creating_dataport"), "error", t(response.msg));
                                                    } else {
                                                        pimcore.helpers.showNotification(t('success'), t('pim.manual.importForm.success'), 'success');
                                                    }
                                                } catch (e) {
                                                    pimcore.helpers.showNotification(t("error"), t("pim.manual.importForm.failure"), "error", e.message);
                                                }
                                            }.bind(this),
                                            failure: function (response) {
                                                var msg = '';
                                                if (response.msg) {
                                                    msg = '<br>' + t(response.msg);
                                                }

                                                Ext.MessageBox.alert(t('error'), t('pim.manual.importForm.failure') + msg);
                                            }.bind(this),
                                            params: {
                                                dataportId: this.dataportId,
                                                ignoreHashCheck: document.getElementById('ignore-hash-check').checked?0:1
                                            }
                                        });
                                    }
                                }.bind(this),
                                icon: Ext.MessageBox.QUESTION
                            });
                        }.bind(this)
                    }, '|', {
                        text: t('pim.manual.startimport.complete'),
                        iconCls: 'pimcore_icon_add',
                        handler: function (b, e) {
                            if (this.formWindow && this.importForm) {
                                this.importForm.getForm().findField('importType').setValue('complete');
                                this.importForm.getForm().findField('importfile').reset();
                                this.formWindow.show();
                            }
                        }.bind(this)
                    }, {
                        text: t('pim.manual.startimport.bmecat'),
                        iconCls: 'pimcore_icon_add',
                        bmecatOnly: true,
                        handler: function (b, e) {
                            if (this.formWindow && this.importForm) {
                                this.importForm.getForm().findField('importType').setValue('bmecat');
                                this.importForm.getForm().findField('importfile').reset();
                                this.formWindow.show();
                            }
                        }.bind(this)
                    }],
                listeners: {
                    destroy: this.stopRefreshing.bind(this),
                    afterrender: this.rebuild.bind(this)
                }
            }]

        });

        pimcore.plugin.Pim.ManualImport.superclass.initComponent.call(this);

        // show the panels by refreshing
        pimcore.layout.refresh();
    },


    rebuild: function () {
        var self = this;
        // this.removeAll();


        this.importForm = Ext.create('Ext.form.Panel', {
            // title: t('pim.manual.importForm.title'),
            fileUpload: true,
            labelWidth: 50,
            bodyStyle: 'padding: 20px;',
            items: [{
                xtype: 'fileuploadfield',
                width: 480,
                emptyText: t('pim.manual.importForm.emptyUpload'),
                fieldLabel: t('pim.manual.importForm.uploadLabel'),
                name: 'importfile',
                buttonText: 'Open File',
                buttonCfg: {
                    iconCls: 'pimcore_icon_file'
                }
            }, {
                xtype: 'hidden',
                name: 'dataportId',
                value: this.dataportId
            }, {
                xtype: 'hidden',
                name: 'importType'
            }],
            buttons: [{
                text: t('pim.manual.importForm.start'),
                handler: function () {
                    if (this.importForm.getForm().isValid()) {
                        this.importForm.getForm().submit({
                            url: pimcore.helpers.addCsrfTokenToUrl('/admin/BlackbitPim/import/manual-import'),
                            waitMsg: t('pim.manual.importForm.waitMsg'),
                            success: function (fp, o) {
                                if (this.formWindow) {
                                    this.formWindow.hide();
                                }
                                Ext.MessageBox.alert(t('success'), t('pim.manual.importForm.success'));
                            }.bind(this),
                            failure: function (form, action) {
                                if (this.formWindow) {
                                    this.formWindow.hide();
                                }

                                var msg = '';
                                if (action.result.msg) {
                                    msg = '<br>' + t(action.result.msg);
                                }

                                Ext.MessageBox.alert(t('error'), t('pim.manual.importForm.failure') + msg);
                            }.bind(this)
                        });
                    }
                }.bind(this)
            }]
        });


        this.formWindow = Ext.create('Ext.Window', {
            layout: 'fit',
            title: t('pim.manual.importForm.title'),
            width: 500,
            height: 300,
            modal: true,
            closeAction: 'hide',

            items: this.importForm
        });

        var readerFields = [
            {name: 'id'},
            {name: 'dataport'},
            {name: 'startDate'},
            {name: 'endDate'},
            {name: 'percentage'},
            {name: 'status'},
            {name: 'type'}
        ];

        this.refreshActive = true;


        Ext.define('JSONImportModel', {
                extend: 'Ext.data.Model',
                fields: readerFields,
                idProperty: 'id'
            }
        );

        var store = Ext.create('Ext.data.JsonStore', {
            model: 'JSONImportModel',

            proxy: {
                type: 'ajax',
                url: '/admin/BlackbitPim/import/get-status/' + this.dataportId,
                reader: {
                    type: 'json',
                    rootProperty: 'status',
                    totalProperty: 'total'
                }

            },
            pageSize: 25,
            autoLoad: {start: 0, limit: 25},

            transform: {
                fn: function (data) {
                    // do some manipulation of the raw data object

                    // console.log(data);

                    return data;
                },
                scope: this
            }
        });


        this.statusGrid = Ext.create('Ext.grid.Panel', {
            flex: 1,
            store: store,
            columns: [
                {header: 'id', dataIndex: 'id', hidden: true},
                {
                    header: t('pim.manual.statusgrid.startDate'),
                    width: 100,
                    dataIndex: 'startDate',
                    xtype: 'datecolumn',
                    format: 'd.m.Y H:i',
                    renderer: function (value) {
                        return value;
                    }.bind(this)
                },
                {
                    header: t('pim.manual.statusgrid.endDate'),
                    width: 100,
                    dataIndex: 'endDate',
                    xtype: 'datecolumn',
                    format: 'd.m.Y H:i',
                    renderer: function (value) {
                        return value;
                    }.bind(this)
                },
                {
                    header: t('pim.manual.statusgrid.type'), width: 200, dataIndex: 'type', renderer: function (v) {
                    return t('pim.manual.statusgrid.type.' + v)
                }
                },
                {
                    header: t('pim.manual.statusgrid.status'),
                    width: 150,
                    flex: 1,
                    dataIndex: 'status',
                    renderer: function (v) {
                        return t('pim.manual.statusgrid.status.' + v)
                    }
                },
                {
                    header: t('pim.manual.statusgrid.progress'),
                    width: 'auto',
                    dataIndex: 'percentage',
                    renderer: function (v) {
                        return v + '%'
                    }
                }
            ],
            bbar: pimcore.helpers.grid.buildDefaultPagingToolbar(store, {pageSize: 25}),

            border: 0,
            title: t('pim.manual.statusgrid.title'),
            iconCls: 'pimcore_icon_table',

            listeners: {
                render: function () {
                    if (self.refreshActive === true) {
                        setInterval(function () {
                            store.load();
                        }, 10000);
                    }
                }
            }
        });

        this.add(this.statusGrid);
        pimcore.layout.refresh();
    },

    stopRefreshing: function () {
        this.refreshActive = false;
    }
});