/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

pimcore.registerNS("pimcore.plugin.Pim.VariantConfig");
pimcore.plugin.Pim.VariantStatusPanel = Ext.extend(Ext.Panel, {
    region: 'north',
    height: 250,
    task: null,
    store: null,
    statusGrid: null,

    initComponent: function() {
        Ext.define('VariantGeneratorStatusModel', {
            extend: 'Ext.data.Model',
            fields: [
                {name: 'variantId'},
                {name: 'status'}
            ],
            idProperty: 'id',
            proxy: {
                type: 'ajax',
                api: {
                    read: '/admin/BlackbitPim/variantgenerator/stategrid',
                }
            }
        });

        this.store = Ext.create('Ext.data.Store', {
            storeId: 'VariantGeneratorStore',
            model: 'VariantGeneratorStatusModel'
        });

        if (this.task == null) {
            this.task = Ext.util.TaskManager.start({
                run: this.updateComponent,
                interval: 20000
            });
        }

        Ext.apply(this, {
            left: 0,
            dockedItems: [
                {
                    xtype: 'toolbar',
                    dock: 'top',
                    items: [
                        {
                            name: 'generateButton',
                            text: t('pim.generate_variant_run'),
                            iconCls: 'pimcore_icon_system',
                            listeners: {
                                click: {
                                    fn: function (buttonElement, node, index) {
                                        buttonElement.setDisabled(true);
                                        Ext.Ajax.request({
                                            url: "/admin/BlackbitPim/variantgenerator/run"
                                        });
                                    }.bind(this)
                                }
                            }
                        }
                    ]
                },
                Ext.create('Ext.grid.Panel', {
                    id: 'VariantGeneratorStatusGrid',
                    flex: 1,
                    height: 200,
                    store: this.store,
                    columns: [
                        {
                            header: 'id',
                            dataIndex: 'variantId'
                        },
                        {
                            header: 'state',
                            dataIndex: 'state',
                            flex: 1
                        }
                    ],
                    bbar: pimcore.helpers.grid.buildDefaultPagingToolbar(
                        this.store,
                        {
                            id: 'VariantGeneratorStatusPaging',
                            pageSize: 25
                        }
                    ),
                    border: 0,
                    title: 'Variant generator status',
                    iconCls: 'pimcore_icon_table',
                })
            ]
        });

        pimcore.plugin.Pim.VariantStatusPanel.superclass.initComponent.call(this);

        pimcore.layout.refresh();
    },

    updateComponent: function() {
        Ext.Ajax.request({
            url: "/admin/BlackbitPim/variantgenerator/state",
            success: function (response) {
                try {
                    var response = Ext.decode(response.responseText);
                    if (Ext.ComponentQuery.query('[name=generateButton]')[0]) {
                        Ext.ComponentQuery.query('[name=generateButton]')[0].setDisabled(response.running);
                    }
                } catch (e) {
                    pimcore.helpers.showNotification(t("error"), e.message, "error");
                }
            }.bind(this)
        });
        try {
            if (Ext.getCmp('VariantGeneratorStatusPaging')) {
                Ext.getCmp('VariantGeneratorStatusPaging').doRefresh();
            }
        } catch (e) {
            pimcore.helpers.showNotification(t("error"), e.message, "error");
        }
    },

    destroyComponent: function() {
        if (this.task) {
            Ext.util.TaskManager.stop(this.task);
        }
    }
});
