<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

namespace Blackbit\PimBundle\Command;


use Blackbit\PimBundle\lib\Pim\Item\ImporterInterface;
use Blackbit\PimBundle\lib\Pim\Item\Importmanager;
use Blackbit\PimBundle\model\ImportStatus;
use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class ImportPimCommand extends AbstractCommand
{
    protected function configure()
    {
        $this
            ->setName('import:pim')
            ->setDescription('Imports rawdata into pimcore objects')
            ->addArgument('dataport',InputArgument::REQUIRED, 'Dataport ID to process')
            ->addArgument('rawitem', InputArgument::OPTIONAL, 'ID of a single rawitem to import')
            ->addOption('ignore-hash-check', null, InputOption::VALUE_NONE, 'Skip hash check and force all raw data to be imported')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $ignoreHashCheck = $input->getOption('ignore-hash-check');

        \Pimcore::getEventDispatcher()->dispatch('pim.initPimImport');
//
//        // TODO: Do this via events
//        if (class_exists('PimMq_Plugin', false)) {
//            // Transfer dats in bulk after import has finished
//            \PimMq_Plugin::setImmediateTransfer(false);
//
//            $helper = \PimMq_Helper::getInstance();
//            if (method_exists($helper, 'setActiveQueue')) {
//                \PimMq_Helper::getInstance()->setActiveQueue(\PimMq_Helper::QUEUETYPE_REGULAR);
//            }
//        }

        \Pimcore\Model\DataObject\AbstractObject::setHideUnpublished(true);

        $dataportId = $input->getArgument('dataport');
        $rawItemId = $input->getArgument('rawitem');

        $output->writeln("Starting pim import for dataport " . $dataportId);
        if (!empty($rawItemId)) {
            if (is_array($rawItemId)) {
                $rawItemId = array_pop($rawItemId);
            }
            $output->writeln('Will only import raw item with id ' . $rawItemId);
        }

        $start = microtime(true);

        $importer = new Importmanager(\Pimcore::getContainer()->get(ImporterInterface::class), \Pimcore::getContainer()->get('pim.logger'), $ignoreHashCheck);
        $importer->importDataport($dataportId, ImportStatus::TYPE_PIM, $rawItemId);

        $duration = microtime(true) - $start;

        $output->writeln("Dauer: {$duration} Sekunden");
    }
}