<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Blackbit\PimBundle\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Pimcore\Migrations\Migration\AbstractPimcoreMigration;

/**
 * Class Version20190529130900
 *
 * @package blackbit\PimBundle\Migrations
 */
class Version20190529130900 extends AbstractPimcoreMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE `plugin_pim_dataport` MODIFY COLUMN `sourcetype`  enum(\'xml\',\'csv\',\'excel\',\'pimcore\',\'variant\',\'bmecat\') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL AFTER `description`');
        $this->addSql(
            'CREATE TABLE `plugin_pim_variant` (
                `id`  int(11) UNSIGNED NOT NULL AUTO_INCREMENT ,
                `name`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
                `description`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT \'\' ,
                `sourcetype`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
                `sourceconfig`  text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
                `targetconfig`  text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
                `parent`  int(11) NOT NULL DEFAULT 0 ,
                PRIMARY KEY (`id`)
                )
                ENGINE=InnoDB
                DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
                ROW_FORMAT=Compact'
        );
        $this->addSql(
            'CREATE TABLE `plugin_pim_variant_generator` (
                `variantId`  int(11) NOT NULL ,
                `state`  varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT \'\' ,
                PRIMARY KEY (`variantId`)
                )
                ENGINE=InnoDB
                DEFAULT CHARACTER SET=utf8mb4 COLLATE=utf8mb4_general_ci
                ROW_FORMAT=Compact'
        );
        $this->addSql(
            'CREATE TABLE `plugin_pim_variant_items` (
                `dataportId`  int(11) UNSIGNED NOT NULL ,
                `fieldNo`  int(11) UNSIGNED NOT NULL ,
                `name`  varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT \'\' ,
                `priority`  tinyint(4) NOT NULL DEFAULT 0 ,
                PRIMARY KEY (`dataportId`, `fieldNo`),
                CONSTRAINT `fk_variantitemfield_dataport` FOREIGN KEY (`dataportId`) REFERENCES `plugin_pim_variant` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
                INDEX `index_variantItemField_dataportId_priority` (`dataportId`, `priority`) USING BTREE 
                )
                ENGINE=InnoDB
                DEFAULT CHARACTER SET=utf8 COLLATE=utf8_general_ci
                ROW_FORMAT=Compact'
            );
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE `plugin_pim_dataport` MODIFY COLUMN `sourcetype`  enum(\'xml\',\'csv\',\'excel\',\'pimcore\',\'bmecat\') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL AFTER `description`');
        $this->addSql('DROP TABLE plugin_pim_variant');
        $this->addSql('DROP TABLE plugin_pim_variant_generator');
        $this->addSql('DROP TABLE ');
    }
}
