<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

namespace Blackbit\PimBundle\model;
use Blackbit\PimBundle\lib\Pim\Parser\PimcoreParser;
use Blackbit\PimBundle\lib\Pim\Parser\Parser;
use Blackbit\PimBundle\Tools\Installer;
use Blackbit\PimBundle\model\PimcoreDbRepository;
use Blackbit\PimBundle\lib\Pim\Parser\XmlParser;
use Blackbit\PimBundle\lib\Pim\Parser\CsvParser;
use Blackbit\PimBundle\lib\Pim\Parser\ExcelParser;
use Psr\Log\LoggerInterface;

class Dataport extends PimcoreDbRepository {
    protected function getTableName(): string
    {
        return Installer::TABLE_DATAPORT;
    }

    /**
     * Returns a matching parser for this dataport
     *
     * @param int $id
     *
     * @return Parser
     * @throws \InvalidArgumentException
     */
	public function getParser($id) {
		$dataport = $this->get($id);
		if (!empty($dataport['sourceconfig'])) {
			$sourceconfig = unserialize($dataport['sourceconfig']);
			switch ($dataport['sourcetype']) {
				case 'xml':
					return new XmlParser($sourceconfig, \Pimcore::getContainer()->get('pim.logger'));
					break;
				case 'csv':
					return new CsvParser($sourceconfig, \Pimcore::getContainer()->get('pim.logger'));
					break;
				case 'excel':
					return new ExcelParser($sourceconfig, \Pimcore::getContainer()->get('pim.logger'));
					break;
                case 'pimcore':
                    $fieldTable = new RawItemField();
                    $fields = $fieldTable->find(['dataportId = ?' => $id]);

                    foreach ($fields as $fieldIndex => $fieldData) {
                        $sourceconfig['fields']['field_'.$fieldData['fieldNo']]['name'] = $fieldData['name'];
                    }

                    return new PimcoreParser($sourceconfig, \Pimcore::getContainer()->get('pim.logger'));
                    break;
			}

            throw new \InvalidArgumentException('Could not get a parser for source type "'.$dataport['sourcetype'].'"');
		}

        throw new \InvalidArgumentException('Please provide source configuration for dataport #'.$id);
	}
}