<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

namespace Blackbit\PimBundle\lib\Pim;

use Pimcore\Logger;

/**
 *
 *
 * @author Dennis Korbginski <dennis.korbginski@blackbit.de>
 * @copyright Blackbit neue Werbung neue Medien GmbH, http://www.blackbit.de/
 */

class Feature {
	const BMECAT = 'bmecat';

	private static $access = array();

	public static function hasFeature($name) {
		if (!function_exists('ioncube_file_is_encoded') || !ioncube_file_is_encoded()) {
			return true;
		}

		if (!array_key_exists($name, self::$access)) {
			$access = false;
			if (function_exists('ioncube_license_properties')) {
				$props = ioncube_license_properties();
				if (is_array($props) && array_key_exists('features', $props) && array_key_exists('value', $props['features'])) {
					$features = $props['features']['value'];

					if (is_array($features) && in_array($name, $features)) {
						$access = true;
					}
				}
			}

			self::$access[$name] = $access;
		}

		return self::$access[$name];
	}

	public static function checkFeature($name) {
		if (!self::hasFeature($name)) {
			switch ($name) {
				case self::BMECAT;
					$message = 'Your license does not grant you access to BMEcat imports.';
					break;

				default:
					$message = 'Your license does not grant you access to this feature.';
			}

			$message .= ' Please upgrade your license at http://shop.blackbit.de/';

			Logger::critical($message);
			throw new \Exception($message);
		}
	}
}