<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Blackbit\PimBundle\Command;

use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Command\LockableTrait;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class VariantgeneratorCommand
 *
 * @package Blackbit\PimBundle\Command
 */
class VariantgeneratorCommand extends AbstractCommand
{
    const LOCK_ID = 'variantGeneratorLock';

    use LockableTrait;

    /**
     * @inheritdoc
     */
    protected function configure()
    {
        $this
            ->setName('import:variants')
            ->setDescription('Generates all variants marked in plugin_pim_variant_generator table');
    }

    /**
     * @inheritdoc
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        if ($this->lock(self::LOCK_ID)) {
            try {
                $this->getContainer()->get('pim.variant.generator')->generateAll();
                $this->release();
            } catch (\Exception $exception) {
                $this->release();
            }
        }
    }
}
