<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

namespace Blackbit\PimBundle\Migrations;

use Blackbit\PimBundle\model\Dataport;
use Blackbit\PimBundle\Tools\Installer;
use Doctrine\DBAL\Schema\Schema;
use Pimcore\Db;
use Pimcore\Migrations\Migration\AbstractPimcoreMigration;

class Version20181101114350 extends AbstractPimcoreMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $dataports = new Dataport();
        foreach($dataports->find() as $dataport) {
            $targetConfig = unserialize($dataport['targetconfig']);
            $this->addSql('INSERT INTO '.Installer::TABLE_FIELDMAPPING.' (dataportId, fieldName, calculation) VALUES (?,?,?)', [
                $dataport['id'],
                'published',
                $targetConfig['itemStatus']
            ]);
        }
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        $dataports = new Dataport();
        $itemStatusCalculations = Db::get()->fetchAll('SELECT dataportId,calculation FROM '.Installer::TABLE_FIELDMAPPING.' WHERE fieldName"path"');
        foreach($itemStatusCalculations as $itemStatusCalculation) {
            $dataport = $dataports->get($itemStatusCalculation['dataportId']);
            $targetConfig = \unserialize($dataport['targetconfig']);

            $targetConfig['itemStatus'] = $itemStatusCalculation['calculation'];
            $targetConfig = \serialize($targetConfig);

            $this->addSql('UPDATE '.Installer::TABLE_DATAPORT.' SET targetconfig = ? WHERE id=?', [
                $targetConfig,
                $dataport['id']
            ]);
        }
    }
}
