<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * Datenstruktur für Object_Class_Data_FlexibleTable
 */

class Object_Data_FlexibleTable {

    /**
     * @var array
     */
    public $data;

    public function __construct($data = array()) {
        if($data) {
            $this->data = $data;
        } else {
	        $this->data = array();
        }
    }

    public function setData($data) {
        $this->data = $data;
    }

    public function getData() {
        return $this->data;
    }


    public function __call($name, $arguments) {
	    /*
        if(substr($name, 0, 3) == "get") {
            $key = strtolower(substr($name, 3, strlen($name)-3));

            $parts = explode("__", $key);
            if(count($parts) == 2) {
                $row = $parts[0];
                $col = $parts[1];

                if(array_key_exists($row, $this->data)) {
                    $rowArray = $this->data[$row];
                    if(array_key_exists($col, $rowArray)) {
                        return $rowArray[$col];
                    }
                }
            } else if(array_key_exists($key, $this->data)) {
                return $this->data[$key];
            }

            throw new Exception("Requested data $key not available");
        }


        if(substr($name, 0, 3) == "set") {
            $key = strtolower(substr($name, 3, strlen($name)-3));

            $parts = explode("__", $key);
            if(count($parts) == 2) {
                $row = $parts[0];
                $col = $parts[1];

                if(array_key_exists($row, $this->data)) {
                    $rowArray = $this->data[$row];
                    if(array_key_exists($col, $rowArray)) {
                        $this->data[$row][$col] = $arguments[0];
                        return;
                    }
                }
            } else if(array_key_exists($key, $this->data)) {
                throw new Exception("Setting a whole row is not allowed.");
            }

            throw new Exception("Requested data $key not available");
        }
		*/
    }

    public function isEmpty() {
        foreach($this->data as $dataRow) {
            foreach($dataRow as $col) {
                if(!empty($col)) {
                    return false;
                }
            }
        }

        return true;
    }

    public function __toString() {

        $string = "<table>";

        foreach($this->data as $key => $dataRow) {
            $string .= "<tr>";
            $string .= "<td><strong>$key</strong></td>";

            foreach($dataRow as $c) {
                $string .= "<td>$c</td>";
            }
            $string .= "</tr>";
        }

        $string .= "</table>";

        return $string;
    }

    public function getHtmlTable($colDefs) {
        $string = "<table>";
        $string .= "<tr>";
        $string .=  "<th><strong></strong></th>";
        foreach($colDefs as $c) {
            $string .= "<th><strong>" . $c['label'] . "</strong></th>";
        }
        $string .= "</tr>";

        $rowDefs = [];
        foreach($rowDefs as $r) {
            if (is_object($r)) {
                $r = (array)$r;
            }

            $dataRow = $this->data[$r['key']];
            $string .= "<tr>";
            $string .= "<th><strong>" . $r['label'] . "</strong></th>";

            foreach($dataRow as $c) {
                $string .= "<td>$c</td>";
            }
            $string .= "</tr>";
        }
        $string .= "</table>";

        return $string;
    }


}
