/*
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

pimcore.registerNS("pimcore.plugin.Pim.ImportConfig");

pimcore.plugin.Pim.ImportConfig = Class.create({

    dataportContainer: null,

    initialize: function (layoutId) {
        this.layoutId = layoutId;

        this.initTreeModel();
        // create layout
        this.getLayout();
    },
    getDataportTree: function () {
        if (!this.tree) {
            this.tree = Ext.create('Ext.tree.Panel', {
                id: "Pim_dataport_tree",
                region: "west",
                collapsible: false,
                useArrows: false,
                autoScroll: true,
                animate: false,
                containerScroll: true,
                border: true,
                width: 350,
                split: true,

                root: {
                    nodeType: 'async',
                    id: '0'
                },

                rootVisible: false,
                lines: false,
                store: this.dataStore,
                listeners: {
                    click: {
                        element: 'el', //bind to the underlying el property on the panel
                        fn: function (sm, node, index) {
                            if (sm && sm.record && sm.record.id) {

                                this.id = sm.record.id;
                                this.onTreeNodeClick()
                            }
                        }.bind(this)
                    }
                },

                tbar: {
                    items: [
                        {
                            text: t("pim.add_dataport"),
                            iconCls: "pimcore_icon_add",
                            handler: this.promptNewDataportName.bind(this)
                        }, '->', {
                            iconCls: "pimcore_icon_reload",
                            handler: function () {
                                this.reloadTree();
                            }.bind(this)
                        }
                    ]
                }
            });

            this.tree.on('itemcontextmenu', function (view, rec, node, index, event) {
                event.stopEvent();
                this.onTreeNodeContextmenu(rec.id, event);

            }.bind(this))


        }
        return this.tree;
    },


    initTreeModel: function () {

        this.dataStore = Ext.create('Ext.data.TreeStore', {
            model: 'ImportDataPortModel',
            root: {
                name: 'Data',
                expanded: true

            }
        });


    },

    getContainer: function () {
        if (!this.dataportContainer) {
            this.dataportContainer = new Ext.TabPanel({
                region: "center",
                listeners: {
                    'tabchange': function (tabpanel, tab) {
                        var dataportId = tab.dataportId;
                        var tree = this.tree;
                        this.tree.getRootNode().cascade(function () {
                            if (this.id === dataportId) {
                                tree.setSelection(this);
                            }
                        });
                    }.bind(this)
                }
            });
        }

        return this.dataportContainer;

    },

    promptNewDataportName: function () {
        Ext.MessageBox.prompt(t('pim.add_dataport'), t('pim.enter_new_dataport_name'), this.addDataport.bind(this), null, null, "");
    },

    addDataport: function (button, value, object) {
        if (button == "ok") {

            Ext.Ajax.request({
                url: "/admin/BlackbitPim/importconfig/add",
                params: {
                    name: value
                },
                success: function (response) {
                    try {
                        var response = Ext.decode(response.responseText);
                        if (!(response && response.success)) {
                            pimcore.helpers.showNotification(t("error"), t("pim.error_creating_dataport"), "error", t(response.errorMessage));
                        }
                    } catch (e) {
                        pimcore.helpers.showNotification(t("error"), t("pim.error_creating_dataport"), "error");
                    }
                    this.reloadTree();
                }.bind(this)
            });
        }
    },

    /**
     * create tab panel
     * @returns Ext.Panel
     */
    getLayout: function () {
        var tabPanel = Ext.getCmp("pimcore_panel_tabs");
        var existingTab = Ext.getCmp(this.layoutId);
        if(existingTab) {
            tabPanel.setActiveItem(this.layoutId);
            return existingTab;
        }

        if (!this.layout) {
            this.layout = new Ext.Panel({
                id: this.layoutId,
                title: t('pim.PIM import config'),
                iconCls: "pimcore_icon_settings",
                border: false,
                layout: "border",
                closable: true,
                items: [this.getDataportTree(), this.getContainer()]
            });

            // add event listener
            var layoutId = this.layoutId;
            this.layout.on("destroy", function () {
                pimcore.globalmanager.remove(layoutId);
            }.bind(this));

            // find the main tabpanel and add ours
            tabPanel.add(this.layout);
            tabPanel.setActiveItem(this.layoutId);

            // show the panels by refreshing
            pimcore.layout.refresh();


        }
        return this.layout;
    },


    getTreeNodeListeners: function () {
        return {
            'click': this.onTreeNodeClick,
            'contextmenu': this.onTreeNodeContextmenu
        };
    },

    reloadTree: function () {
        if (this.tree) {
            this.dataStore.reload();
        }
    },

    getOpenPanels: function (dataportId) {
        var panels = [];
        try {
            var container = this.getContainer();

            container.items.each(function (child, index, total) {
                if (child.dataport && child.dataport.id == dataportId) {
                    panels.push(child);
                }
            });

        } catch (e) {
            console.log(e);
        }
        return panels;
    },

    removeOpenPanel: function (dataportId) {
        var container = this.getContainer();

        var toBeRemoved = this.getOpenPanels(dataportId);
        Ext.each(toBeRemoved, function (panel) {
            container.remove(panel);
        });
    },

    onTreeNodeClick: function () {
        // console.log("IDEX ", this);


        if (this.id > 0) {
            //  console.log("onTreeNodeClick ", this);
            var container = this;

            var existingPanels = container.getOpenPanels(this.id);

            if (existingPanels.length > 0) {
                existingPanels[0].show();
            } else {
                var dataportContainer = container.getContainer();
                dataportContainer.add(Ext.create('pimcore.plugin.Pim.DataportPanel', {
                    dataportId: this.id
                })).show();
            }

            pimcore.layout.refresh();
        }

    },

    onTreeNodeContextmenu: function (index, event) {
        //  this.select();


        var menu = Ext.create('Ext.menu.Menu');
        menu.add(Ext.create('Ext.menu.Item', {
            text: t('delete'),
            iconCls: "pimcore_icon_delete",
            handler: function () {

                Ext.Msg.confirm(t('delete'), t('pim.delete_dataport_message'), function (btn) {
                    if (btn == 'yes') {
                        Ext.Ajax.request({
                            url: "/admin/BlackbitPim/importconfig/delete/"+index
                        });
                        this.removeOpenPanel(index);
                        this.reloadTree();
                    }
                }.bind(this));
            }.bind(this)

        }));

        //menu.show(this.ui.getAnchor());
        menu.showAt(event.getXY());
    }
});