/*
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

pimcore.registerNS("Pim.importConfig");
Pim.ConfigPanel = Ext.extend(Ext.Panel, {
	dataportId: null,
	comparisonResult: null,

	rawdataTree: null,
	pimTree: null,
	rawdataTreeFilter: null,
	rawdataHideProducts: true,

	rawdataAttributes: null,
	pimAttributes: null,

	initComponent: function() {
		Ext.apply(this, {
			border: false,
			layout: 'fit'
		});

		Pim.ConfigPanel.superclass.initComponent.call(this);
	},

	load: function(dataportId, comparisonResult) {
		var self = this;
		this.removeAll();

		this.dataportId = dataportId;
		this.comparisonResult = comparisonResult;

		var submitRawdataTreeSearch = function() {
			var field = Ext.getCmp('bmecatSearchRawdata');
			var loader = self.rawdataTree.getLoader();

			if (field.getValue()) {
				loader.baseParams.filter = field.getValue();
			} else {
				delete loader.baseParams.filter;
			}

			loader.load(self.rawdataTree.getRootNode());
		};

		this.rawdataTree = new Ext.ux.tree.TreeGrid({
//			title: t('pim.dataport.bmecat.configPanel.rawdataTree'),
			flex: 1,
			region: 'west',
			width: '50%',
//			border: false,

			tbar: [
				t('pim.dataport.bmecat.configPanel.rawdataTree'),
				'->', {
					id: 'bmecatSearchRawdata',
					xtype: 'textfield',
					enableKeyEvents: true,
					listeners: {
						keyup: function(field, e) {
							if (e.keyCode == 13) {
								submitRawdataTreeSearch();
							}
						}
					}
				}, {
					xtype: 'button',
					text: t('pim.dataport.bmecat.search'),
					listeners: {
						'click': submitRawdataTreeSearch
					}
				},
				'-',
				{
					xtype: 'button',
					text: 'Produkte anzeigen',
					enableToggle: true,
					toggleHandler: function(btn, state) {
						if (self.rawdataTreeFilter) {
							self.rawdataHideProducts = state !== true;
						}

						if (self.rawdataHideProducts === true) {
							self.rawdataTreeFilter.filter('category', 'dataType');
						} else {
							self.rawdataTreeFilter.clear();
						}
					}
				}
			],

			enableDrag: true,
			dragConfig: {
				ddGroup: 'categoryMapping'
			},

			columns: [{
				header: 'Kategorie',
				dataIndex: 'name',
				width: 230,
				sortType: 'asUCString'
			},{
				header: 'ID',
				width: 100,
				dataIndex: 'id',
				align: 'center',
				sortType: 'asUCString'
			},{
				header: '# Artikel',
				width: 100,
				dataIndex: 'itemCount',
				align: 'center',
				sortType: 'asInt'
			}],

			rootVisible: false,
			root: new Ext.tree.AsyncTreeNode({
				id: '_root'
			}),

			loader: new Ext.tree.TreeLoader({
				dataUrl:'/admin/BlackbitPim/Bmecat/get-rawdata-tree',
				baseParams: {
					dataportId: self.dataportId
				}
			}),

			listeners: {
				click: function(node, e) {
					this.loadNodeAttributes(node);
				},
				load: function(node) {
					if (self.rawdataHideProducts === true) {
						self.rawdataTreeFilter.filter('category', 'dataType', node);
					}
				}
			},

			loadNodeAttributes: function(node) {
				self.rawdataAttributes.getStore().load({
					params: {
						node: node.id
					}
				});

				var showBtn = Ext.getCmp('btnShowRawDataMappings');
				if (node.attributes.dataType == 'category') {
					showBtn.enable();
				} else {
					showBtn.disable();
				}

				var selectedTargetCategory = self.pimTree.getSelectionModel().getSelectedNode();
				if (selectedTargetCategory) {
					self.pimAttributes.getStore().load({
						params: {
							node: selectedTargetCategory.id,
							sourceCategory: node.id
						}
					});
				}
			}
		});

		this.rawdataTree.loader.createNode = function(attr) {
			if (attr.dataType == 'category') {
				if (self.comparisonResult.categories.new.indexOf(attr.id) >= 0) {
					attr.cls = (attr.cls || '') + ' bb_pim_node_is_new';
				} else if (self.comparisonResult.categories.changed.indexOf(attr.id) >= 0) {
					attr.cls = (attr.cls || '') + ' bb_pim_node_is_changed';
				}
			} else if (attr.dataType == 'product') {
				if (self.comparisonResult.products.new.indexOf(attr.realId) >= 0) {
					attr.cls = (attr.cls || '') + ' bb_pim_node_is_new';
				} else if (self.comparisonResult.products.changed.indexOf(attr.realId) >= 0) {
					attr.cls = (attr.cls || '') + ' bb_pim_node_is_changed';
				}
			}

			return Ext.tree.TreeLoader.prototype.createNode.call(this, attr);
		};




		var submitPimTreeSearch = function() {
			var field = Ext.getCmp('bmecatSearchPimdata');
			var loader = self.pimTree.getLoader();

			if (field.getValue()) {
				loader.baseParams.filter = field.getValue();
			} else {
				delete loader.baseParams.filter;
			}

			loader.load(self.pimTree.getRootNode());
		};

		this.pimTree = new Ext.ux.tree.TreeGrid({
//			title: t('pim.dataport.bmecat.configPanel.pimTree'),
			flex: 1,
			region: 'center',
//			border: false,

			enableDrop: true,
			tbar: [
				t('pim.dataport.bmecat.configPanel.pimTree'),
				'->', {
					id: 'bmecatSearchPimdata',
					xtype: 'textfield',
					enableKeyEvents: true,
					listeners: {
						keyup: function(field, e) {
							if (e.keyCode == 13) {
								submitPimTreeSearch();
							}
						}
					}
				}, {
					xtype: 'button',
					text: t('pim.dataport.bmecat.search'),
					listeners: {
						'click': submitPimTreeSearch
					}
				}
			],

			dropConfig: {
				ddGroup: 'categoryMapping',
				allowContainerDrop: false,
//				appendOnly: true,
				onNodeDrop: function(target, dd, e, data) {
					if (data.node.attributes.dataType != 'category') {
						return false;
					}

					self.pimTree.getEl().mask();

					Ext.Ajax.request({
						url: "/admin/BlackbitPim/Bmecat/save-category-mapping",
						method: 'post',
						params: {
							dataportId: self.dataportId,
							sourceId: data.node.id,
							targetId: target.node.id
						},
						success: function(response) {
							response = Ext.decode(response.responseText);
							self.pimTree.getEl().unmask();

							if (!(response && response.success)) {
								pimcore.helpers.showNotification(t("error"), t(response.errorMessage || 'pim.dataport.bmecat.saveMappingError'), "error");
							} else {
								self.pimTree.getSelectionModel().select(target.node);
								self.pimTree.loadNodeAttributes(target.node);
								self.rawdataTree.loadNodeAttributes(data.node);
							}
						},
						failure: function(response) {
							self.pimTree.getEl().unmask();
							response = Ext.decode(response.responseText);

							pimcore.helpers.showNotification(t("error"), t(response.errorMessage || 'pim.dataport.bmecat.saveMappingError'), "error");
						}
					});

					return true;
				},
				onNodeOver: function(n, source, e, data) {
					var node = n.node;
					if (data.node.attributes.dataType != 'category') {
						return Ext.dd.DropZone.prototype.dropNotAllowed;
					}

					// auto node expand check
					if(!this.expandProcId && node.hasChildNodes() && !n.node.isExpanded()){
						this.queueExpand(node);
					} else {
						this.cancelExpand();
					}

					return 'x-tree-drop-ok-append';
				}
			},

			columns: [{
				header: 'Kategorie',
				dataIndex: 'name',
				width: 230,
				sortType: 'asUCString'
			},{
				header: 'ID',
				width: 100,
				dataIndex: 'id',
				align: 'center',
				sortType: 'asUCString'
			}],

			rootVisible: false,
			root: new Ext.tree.AsyncTreeNode({
				id: '_root'
			}),

			loader: new Ext.tree.TreeLoader({
				dataUrl:'/admin/BlackbitPim/Bmecat/get-pim-tree',
				baseParams: {
					dataportId: self.dataportId
				}
			}),

			listeners: {
				click: function(node, e) {
					this.loadNodeAttributes(node);
				}
			},

			loadNodeAttributes: function(node) {
				var selectedSourceCategory = self.rawdataTree.getSelectionModel().getSelectedNode();

				var showBtn = Ext.getCmp('btnShowPimMappings');
				showBtn.enable();

				if (selectedSourceCategory) {
					self.pimAttributes.getStore().load({
						params: {
							node: node.id,
							sourceCategory: selectedSourceCategory.id
						}
					});
				} else {
					self.pimAttributes.getView().emptyText = t('pim.dataport.bmecat.noSourceCategorySelected');
					self.pimAttributes.getStore().removeAll();
				}
			}
		});

		this.rawdataAttributes = new Ext.grid.GridPanel({
			flex: 1,
			region: 'west',
			width: '50%',
//			border: false,
			currentCategory: null,

			ddGroup: 'attributeMapping',
			enableDragDrop: true,

			loadMask: true,
			tbar: [
				{
					id: 'btnShowRawDataMappings',
					text: 'Alle Mappings anzeigen',
					iconCls: "pimcore_icon_system",
					disabled: true,
					handler: function() {
						var selectedSourceCategory = self.rawdataTree.getSelectionModel().getSelectedNode();

						if (selectedSourceCategory) {
							// create the data store
							var store = new Ext.data.JsonStore({
								autoSave: true,
								proxy: new Ext.data.HttpProxy({
									api: {
										read: '/admin/BlackbitPim/Bmecat/get-mappings-for-source',
										destroy  : { url: '/admin/BlackbitPim/Bmecat/delete-mappings-by-id', method: 'POST' }
									}
								}),
								root: 'data',
								idProperty: 'id',
								fields: [
									'id',
									'categoryId',
									'name'
								],
								writer: new Ext.data.JsonWriter({
									encode: true,
									writeAllFields: true // write all fields, not just those that changed
								}),
								baseParams: {
									dataportId: self.dataportId
								},
								listeners: {
									save: function() {
										self.pimAttributes.refresh();
									}
								}
							});

							var title = selectedSourceCategory.attributes.name + ' (' + selectedSourceCategory.id + ')';
							var w = self.createMappingPopup(title, store, selectedSourceCategory.id);
							w.show();
						}
					}
				}, '-', {
					xtype: 'textfield',
					emptyText: t('pim.dataport.bmecat.search'),
					enableKeyEvents: true,
					listeners: {
						keyup: function(field) {
							var filterValue = field.getValue();
							var store = field.findParentByType('grid').getStore();

							if (!filterValue) {
								store.clearFilter();
							} else {
								store.filter('name', filterValue, true);
							}
						}
					}
				},
				'->', {
					iconCls: "pimcore_icon_reload",
					handler: function() {
						self.rawdataAttributes.refresh();
					}
				}
			],

			store: new Ext.data.GroupingStore({
				proxy: new Ext.data.HttpProxy({
					api: {
						read: '/admin/BlackbitPim/Bmecat/get-rawdata-attributes'
					}
				}),
				reader: new Ext.data.JsonReader({
					root: 'data',
					idProperty: 'id',
					fields: ['id', 'name', 'values', 'groupKey', 'groupName']
				}),
				groupField: 'groupKey',
				baseParams: {
					dataportId: self.dataportId
				}
			}),
			colModel: new Ext.grid.ColumnModel({
				defaults: {
					sortable: true
				},
				columns: [
					{header: 'Collection', dataIndex: 'groupKey', hidden: true, groupRenderer: function(v, unused, r) {
						return t('pim.dataport.bmecat.' + v);
					}},
					{
						header: 'Name',
						dataIndex: 'name',
						renderer: function(value, metaData, record) {
							if (record.get('groupKey') == 'global' && Ext.isString(value) && value.indexOf('Preis') !== 0) {
								return t(value);
							}

							return value;
						}
					},
					{header: 'Werte', dataIndex: 'values'},
					{
						header: 'M',
						xtype: 'actioncolumn',
						width: 20,
						sortable: false,
						menuDisabled: true,
						items: [{
							tooltip: 'Mappings',
							icon: "/bundles/pimcoreadmin/img/flat-color-icons/import.svg",
							handler: function (grid, rowIndex) {
								var record = grid.getStore().getAt(rowIndex);
								var selectedSourceCategory = self.rawdataTree.getSelectionModel().getSelectedNode();

								if (selectedSourceCategory) {
									// create the data store
									var store = new Ext.data.GroupingStore({
										autoSave: true,
										proxy: new Ext.data.HttpProxy({
											api: {
												read: '/admin/BlackbitPim/Bmecat/get-attribute-mappings-for-source'
											}
										}),
										reader: new Ext.data.JsonReader({
											root: 'data',
											idProperty: 'hash',
											fields: [
												'hash',
												'id',
												'fieldCollection',
												'groupId',
												'groupName',
												'field',
												'locale',
												'targetCategoryName',
												'targetFieldName',
												'targetCategoryId'
											]
										}),
										groupField: 'groupId',
										baseParams: {
											dataportId: self.dataportId
										},
										listeners: {
											save: function() {
												self.pimAttributes.refresh();
											}
										}
									});

									var title = record.get('name') + ' (' + record.get('id') + ')';
									var w = self.createAttributeMappingPopup(title, store, {
										xpath: record.get('id')
									}, function(err, catId) {
										if (!err) {
											self.pimAttributes.refresh();
										}
									});
									w.show();
								}
							}.bind(this)
						}]
					}, {
						header: 'I',
						xtype: 'actioncolumn',
						width: 20,
						sortable: false,
						menuDisabled: true,
						items: [{
							tooltip: 'Werte',
							icon: "/bundles/pimcoreadmin/img/flat-color-icons/info.svg",
							handler: function (grid, rowIndex) {
								var record = grid.getStore().getAt(rowIndex);
								var selectedSourceCategory = self.rawdataTree.getSelectionModel().getSelectedNode();

								if (selectedSourceCategory) {
									// create the data store
									var store = new Ext.data.JsonStore({
										autoSave: true,
										proxy: new Ext.data.HttpProxy({
											api: {
												read: '/admin/BlackbitPim/Bmecat/get-example-data'
											}
										}),
										root: 'data',
										idProperty: 'value',
										fields: [
											'value',
											'count',
											'ids'
										],
										baseParams: {
											dataportId: self.dataportId,
											node: selectedSourceCategory.id
										}
									});

									var title = record.get('name') + ' (' + record.get('id') + ')';
									var w = new Ext.Window({
										layout: 'anchor',
										title: title,
										width: 600,
										height: 400,
										closable: true,
										resizable: true,
										draggable: true,
										modal: true,
										items: [{
											xtype: 'grid',
											store: store,
											anchor: '0, 0',
											border: false,
											loadMask: true,
											columns: [
												{
													header   : 'Wert',
													sortable : true,
													dataIndex: 'value'
												},
												{
													header   : 'Anzahl',
													sortable : true,
													dataIndex: 'count'
												},
												{
													header   : 'IDs',
													sortable : true,
													dataIndex: 'ids'
												}
											],
											stripeRows: true,
											viewConfig: {
												forceFit: true,
												emptyText: t('pim.dataport.bmecat.noData')
											},
											listeners: {
												afterrender: function() {
													store.load({
														params: {
															xpath: record.get('id')
														}
													});
												}
											}
										}]
									});
									w.show();
								}
							}.bind(this)
						}]
					}
				]
			}),
			view: new Ext.grid.GroupingView({
				forceFit: true,
				showGroupName: false,
				groupTextTpl: '{text}'
			}),
			sm: new Ext.grid.RowSelectionModel({singleSelect:true}),
			refresh: function() {
				var selectedSourceCategory = self.rawdataTree.getSelectionModel().getSelectedNode();

				if (selectedSourceCategory) {
					self.rawdataAttributes.getStore().load({
						params: {
							node: selectedSourceCategory.id
						}
					});
				}
			}
		});

		this.pimAttributes = new Ext.grid.GridPanel({
			flex: 1,
			region: 'center',
//			border: false,
			currentCategory: null,

			loadMask: true,
			tbar: [{
				id: 'btnShowPimMappings',
				text: 'Alle Mappings anzeigen',
				iconCls: "pimcore_icon_system",
				disabled: true,
				handler: function() {
					var selectedTargetCategory = self.pimTree.getSelectionModel().getSelectedNode();

					if (selectedTargetCategory) {
						// create the data store
						var store = new Ext.data.JsonStore({
							autoSave: true,
							proxy: new Ext.data.HttpProxy({
								api: {
									read: '/admin/BlackbitPim/Bmecat/get-mappings-for-target',
									destroy  : { url: '/admin/BlackbitPim/Bmecat/delete-mappings-by-id', method: 'POST' }
								}
							}),
							root: 'data',
							idProperty: 'id',
							fields: [
								'id',
								'categoryId',
								'name'
							],
							writer: new Ext.data.JsonWriter({
								encode: true,
								writeAllFields: true // write all fields, not just those that changed
							}),
							baseParams: {
								dataportId: self.dataportId
							},
							listeners: {
								save: function() {
									self.pimAttributes.refresh();
								}
							}
						});

						var title = selectedTargetCategory.attributes.name + ' (' + selectedTargetCategory.id + ')';
						var w = self.createMappingPopup(title, store, selectedTargetCategory.id);
						w.show();
					}
				}
			}, '-', {
				xtype: 'textfield',
				emptyText: t('pim.dataport.bmecat.search'),
				enableKeyEvents: true,
				listeners: {
					keyup: function(field) {
						var filterValue = field.getValue();
						var store = field.findParentByType('grid').getStore();

						if (!filterValue) {
							store.clearFilter();
						} else {
							store.filter('name', filterValue, true);
						}
					}
				}
			}, '->', {
				iconCls: "pimcore_icon_reload",
				handler: function() {
					self.pimAttributes.refresh();
				}
			}
			],
			store: new Ext.data.GroupingStore({
				autoSave: true,
				proxy: new Ext.data.HttpProxy({
					api: {
						read: '/admin/BlackbitPim/Bmecat/get-pim-attributes',
						create  : { url: '/admin/BlackbitPim/Bmecat/save-attribute-mapping', method: 'POST' },
						update  : { url: '/admin/BlackbitPim/Bmecat/save-attribute-mapping', method: 'POST' }
					}
				}),
				reader: new Ext.data.JsonReader({
					root: 'data',
					idProperty: 'id',
					fields: [
						'id',
						'name',
						'dataType',
						'groupKey',
						'groupName',
						'groupPosition',
						'mapped',
						'xpath',
						'inherited',
						'calculation',
						'format',
						{ name: 'keyMapping', type: 'boolean' },
						'tooltip'
					]
				}),
				writer: new Ext.data.JsonWriter({
					encode: true,
					writeAllFields: true // write all fields, not just those that changed
				}),
				groupField: 'groupKey',
				baseParams: {
					dataportId: self.dataportId
				},
				listeners: {
					beforeload: function() {
						self.pimAttributes.getView().emptyText = t('pim.dataport.bmecat.unmappedPimCategory');
					},
					beforesave: function(store) {
						var selectedSourceCategory = self.rawdataTree.getSelectionModel().getSelectedNode();
						var selectedTargetCategory = self.pimTree.getSelectionModel().getSelectedNode();

						store.setBaseParam('node', selectedTargetCategory.id);
						store.setBaseParam('sourceCategory', selectedSourceCategory.id);
					},
					save: function(store) {
						store.setBaseParam('node', null);
						store.setBaseParam('sourceCategory', null);
					}
				}
			}),
			colModel: new Ext.grid.ColumnModel({
				defaults: {
					sortable: true
				},
				columns: [
					{
						header: 'K',
						width: 16,
						xtype: 'actioncolumn',
						sortable: false,
						menuDisabled: true,
						items: [{
//							tooltip: 'Schlüsselattribut',
							icon: "/bundles/blackbitpim/img/blank.png",
							getClass: function(v, metadata, record) {
								if (record.get('keyMapping') === true) {
									return 'pim_icon_key';
								}
								return '';
							},
							handler: function (grid, rowIndex) {
								var r = grid.getStore().getAt(rowIndex);
								if (r.get('groupKey') == 'class') {
									r.set('keyMapping', !r.get('keyMapping'));
								}
							}.bind(this)
						}]
					},
					{header: 'Collection', dataIndex: 'groupKey', hidden: true, groupRenderer: function(v, unused, r) {
						return r.get('groupName') || v;
					}},
					{
						header: 'Name',
						dataIndex: 'name',
						renderer: function(value, metadata, record) {
							var tooltip = record.get('tooltip');

							if (tooltip) {
								metadata.attr = 'ext:qtip="' + tooltip + '"';
							}

							return value;
						}
					},
					{header: 'Typ', dataIndex: 'dataType'},
					{
						header: 'Mapping',
						dataIndex: 'xpath',
						renderer: function(value, metadata, record) {
							var record = self.rawdataAttributes.getStore().getById(value);
							if (record && record.get('name')) {
								return record.get('name');
							}

							return value;
						}
					},
					{
						header: 'JS',
						xtype: 'actioncolumn',
						width: 20,
						sortable: false,
						menuDisabled: true,
						items: [{
							tooltip: 'JS-Formel',
							icon: "/bundles/pimcoreadmin/img/flat-color-icons/services.svg",
							getClass: function(v, metadata, record) {
								var calculation = record.get('calculation');
								if (calculation) {
									metadata.css = 'mapping-has-formula';
								}
							},
							handler: function (grid, rowIndex) {
								self.showSettingsWindow(grid.getStore().getAt(rowIndex));
							}.bind(this)
						}]
					},
					{
						header: 'M',
						xtype: 'actioncolumn',
						width: 20,
						sortable: false,
						menuDisabled: true,
						items: [{
							tooltip: 'Mappings',
							icon: "/bundles/pimcoreadmin/img/flat-color-icons/import.svg",
							handler: function (grid, rowIndex) {
								var record = grid.getStore().getAt(rowIndex);
								var selectedSourceCategory = self.rawdataTree.getSelectionModel().getSelectedNode();

								if (selectedSourceCategory) {
									// create the data store
									var store = new Ext.data.GroupingStore({
										autoSave: true,
										proxy: new Ext.data.HttpProxy({
											api: {
												read: '/admin/BlackbitPim/Bmecat/get-attribute-mappings-for-target'
											}
										}),
										reader: new Ext.data.JsonReader({
											root: 'data',
											idProperty: 'hash',
											fields: [
												'hash',
												'id',
												'fieldCollection',
												'groupId',
												'groupName',
												'field',
												'locale',
												'targetCategoryName',
												'targetFieldName',
												'targetCategoryId'
											]
										}),
										groupField: 'groupId',
										baseParams: {
											dataportId: self.dataportId
										},
										listeners: {
											save: function() {
												self.pimAttributes.refresh();
											}
										}
									});

									var title = record.get('name') + ' (' + record.get('id') + ')';
									var w = self.createAttributeMappingPopup(title, store, {
										field: record.get('id')
									}, function(err, catId) {
										if (!err) {
											self.pimAttributes.refresh();
										}
									});
									w.show();
								}
							}.bind(this)
						}]
					}
				]
			}),
			view: new Ext.grid.GroupingView({
				forceFit: true,
				showGroupName: false,
				groupTextTpl: '{text}',
				getRowClass: function(record, rowIndex, rp, ds) {
					var classes = [];
					if (record.get('inherited')) {
						classes.push('attribute-is-inherited');
					} else if (record.get('mapped') == true) {
						classes.push('attribute-is-mapped');
					}

					if (record.get('keyMapping')) {
						classes.push('attribute-is-key');
					}

					return classes.join(' ');
				}
			}),
			sm: new Ext.grid.RowSelectionModel({singleSelect:true}),
			listeners: {
				render: function(grid) {
					grid.dropZone = new Ext.dd.DropZone(grid.getView().scroller, {
						ddGroup: 'attributeMapping',

						//      If the mouse is over a grid row, return that node. This is
						//      provided as the "target" parameter in all "onNodeXXXX" node event handling functions
						getTargetFromEvent: function(e) {
							return e.getTarget(grid.getView().rowSelector);
						},

						//      On entry into a target node, highlight that node.
//						onNodeEnter : function(target, dd, e, data){
//							Ext.fly(target).addClass('my-row-highlight-class');
//						},

						//      On exit from a target node, unhighlight that node.
//						onNodeOut : function(target, dd, e, data){
//							Ext.fly(target).removeClass('my-row-highlight-class');
//						},

						//      While over a target node, return the default drop allowed class which
						//      places a "tick" icon into the drag proxy.
						onNodeOver : function(target, dd, e, data){
//							var match = data.node.id.match(/^d([0-9]+)-field[0-9]+$/);
//							if (match && match[1] == mappingPanel.dataportId) {
//								return Ext.dd.DropZone.prototype.dropAllowed;
//							} else {
//								return Ext.dd.DropZone.prototype.dropNotAllowed;
//							}

							return Ext.dd.DropZone.prototype.dropAllowed;
						},

						//      On node drop we can interrogate the target to find the underlying
						//      application object that is the real target of the dragged data.
						//      In this case, it is a Record in the GridPanel's Store.
						//      We can use the data set up by the DragZone's getDragData method to read
						//      any data we decided to attach in the DragZone's getDragData method.
						onNodeDrop : function(target, dd, e, data) {
							var rowIndex = grid.getView().findRowIndex(target);
							var r = grid.getStore().getAt(rowIndex);

							var source = self.rawdataAttributes.getStore().getAt(data.rowIndex);

//							Ext.Msg.alert('Drop gesture', 'Dropped Record ' + source.id +
//								' on Record id ' + r.id);

							r.beginEdit();
							r.set('xpath', source.id);
							r.set('mapped', true);
							r.set('inherited', false);
							r.endEdit();
						}
					});
				}
			},

			refresh: function() {
				var selectedSourceCategory = self.rawdataTree.getSelectionModel().getSelectedNode();
				var selectedTargetCategory = self.pimTree.getSelectionModel().getSelectedNode();

				if (selectedSourceCategory && selectedTargetCategory) {
					self.pimAttributes.getStore().load({
						params: {
							node: selectedTargetCategory.id,
							sourceCategory: selectedSourceCategory.id
						}
					});
				}
			}
		});

		// Filter für Rohdaten
		this.rawdataTreeFilter = new Ext.tree.TreeFilter(this.rawdataTree);

		this.add({
			xtype: 'container',
			layout: 'border',
			defaults: {
				collapsible: false,
				split: true
			},
			items: [{
				layout: 'border',
				defaults: {
					collapsible: false,
					split: true
				},
				region: 'south',
				height: 300,
				minSize: 100,
				items: [this.rawdataAttributes, this.pimAttributes]
			}, {
				layout: 'border',
				defaults: {
					collapsible: false,
					split: true
				},
				region: 'center',
				items: [this.rawdataTree, this.pimTree]
			}]
		});



		self.updateLayout();
		pimcore.layout.refresh();
	},

	showSettingsWindow: function(record) {
		var self = this;
		var format = record.get('format') || {};

		var fields = [];

		if (record.get('groupKey') == 'class') {
			fields.push({
				xtype: 'checkbox',
//				anchor: '100%',
				name: 'keyMapping',
				fieldLabel: 'Schlüsselattribut',
				value: true,
				checked: record.get('keyMapping') === true
			});
		}

		switch (record.get('dataType')) {
			case 'numeric':
				fields.push({
					xtype: 'textfield',
//					anchor: '100%',
					name: 'groupingSeparator',
					fieldLabel: 'Tausendertrennzeichen',
					value: format.groupingSeparator
				}, {
					xtype: 'textfield',
					name: 'decimalSeparator',
					fieldLabel: 'Dezimaltrennzeichen',
					value: format.decimalSeparator
				});

				break;

			case 'date':
			case 'datetime':
				fields.push({
					xtype: 'textfield',
//					anchor: '100%',
					name: 'dateFormat',
					fieldLabel: 'Datumsformat',
					value: format.dateFormat
				});

				break;

			case 'multiselect':
				fields.push({
					xtype: 'textfield',
//					anchor: '100%',
					name: 'separator',
					fieldLabel: 'Trennzeichen',
					value: format.separator
				});

				break;
		}

		var selectedSourceCategory = self.rawdataTree.getSelectionModel().getSelectedNode();
		var selectedTargetCategory = self.pimTree.getSelectionModel().getSelectedNode();

		var store = new Ext.data.JsonStore({
			proxy: new Ext.data.HttpProxy({
				api: {
					read  : { url: '/admin/BlackbitPim/Bmecat/get-preview', method: 'POST' }
				}
			}),
			root: 'data',
			idProperty: 'id',
			fields: ['id', 'preview'],
			baseParams: {
				dataportId: self.dataportId,
				targetField: record.get('id'),
				xpath: record.get('xpath'),
				sourceCategoryId: selectedSourceCategory.id,
				targetCategoryId: selectedTargetCategory.id
			}
		});

		var toolbar = new Ext.PagingToolbar({
			pageSize: 5,
			store: store,
			displayInfo: true,
			listeners: {
				'beforechange': function(tb) {
					var formPanel = tb.findParentByType('form'),
						form = formPanel.getForm(),
						values = form.getFieldValues();

					store.setBaseParam('calculation', values.calculation);
				}
			}
		});

		var previewGrid = new Ext.grid.GridPanel({
			height: 200,
			autoExpandColumn: 'preview',
			store: store,
			colModel: new Ext.grid.ColumnModel({
				defaults: {
					width: 150,
					sortable: false
				},
				columns: [
					{ header: 'Artikel-ID', dataIndex: 'id', width: 150 },
					{ header: 'Preview', dataIndex: 'preview', width: 500 }
				]
			}),
			viewConfig: {
				forceFit: true
			},
			// paging bar on the bottom
			bbar: toolbar,
			listeners: {
				afterrender: function(grid) {
					grid.getStore().load();
				}
			}
		});


		var save = function(button) {
			record.beginEdit();
			var formPanel = button.findParentByType('form');

			var form = formPanel.getForm();
			var values = form.getFieldValues();

			if (format) {
				var newFormat = {};
				if (format.decimalSeparator) {
					newFormat.decimalSeparator = values.decimalSeparator;
				}
				if (format.groupingSeparator) {
					newFormat.groupingSeparator = values.groupingSeparator;
				}
				if (format.separator) {
					newFormat.separator = values.separator;
				}
				if (format.dateFormat) {
					newFormat.dateFormat = values.dateFormat;
				}

				record.set('format', newFormat);
			}

			record.set('calculation', values.calculation);
			record.set('keyMapping', values.keyMapping === true);
			record.endEdit();
		};

		fields.push({
			xtype: 'textarea',
//			anchor: '100%',
			name: 'calculation',
			fieldLabel: 'Formel',
			width: '98%',
			height: 150,
			value: record.get('calculation')
		}, previewGrid, {
			'xtype': 'spacer',
			'height': 20
		}, {
			xtype: 'button',
			text: t('pim.mapping.savebutton'),
			handler: save
		});

		var settingsForm = new Ext.form.FormPanel({
//			layout: 'vbox',
			frame: true,
			labelWidth: 150,
			items: fields
		});

		var settingsWindow = new Ext.Window({
			layout: 'fit',
			title: t('pim.settingspanel.caption'),
			width: 750,
			height: 500,
			closable: true,
			resizable: false,
			draggable: true,
			modal: true,
			items: [settingsForm]
		});

		settingsWindow.show();
	},

	createMappingPopup: function(title, store, nodeId) {
		return new Ext.Window({
			layout: 'anchor',
			title: title,
			width: 600,
			height: 400,
			closable: true,
			resizable: true,
			draggable: true,
			modal: true,
			items: [{
				xtype: 'grid',
				store: store,
				anchor: '0, 0',
				border: false,
				loadMask: true,
				columns: [
					{
						header   : 'ID',
						width    : 50,
						sortable : true,
						dataIndex: 'categoryId'
					},
					{
						header   : 'Kategorie',
//						width    : 160,
						sortable : true,
						dataIndex: 'name'
					},
					{
						xtype: 'actioncolumn',
						width: 50,
						items: [{
							icon   : '/bundles/pimcoreadmin/img/flat-color-icons/empty_trash.svg',  // Use a URL in the icon config
							tooltip: 'Löschen',
							handler: function(grid, rowIndex, colIndex) {
								var rec = grid.getStore().getAt(rowIndex);

								Ext.Msg.confirm(t('delete'), t('pim.dataport.bmecat.confirmDeleteMapping'), function(btn) {
									if (btn == 'yes') {
										grid.getStore().remove(rec);
									}
								});
							}
						}]
					}
				],
				stripeRows: true,
				autoExpandColumn: 'name',
				viewConfig: {
					forceFit: true,
					emptyText: t('pim.dataport.bmecat.noMapping')
				},
				listeners: {
					afterrender: function() {
						store.load({
							params: {
								node: nodeId
							}
						});
					}
				}
			}]
		});
	},

	createAttributeMappingPopup: function(title, store, idParams, cb) {
		return new Ext.Window({
			layout: 'anchor',
			title: title,
			width: 600,
			height: 400,
			closable: true,
			resizable: true,
			draggable: true,
			modal: true,
			items: [{
				xtype: 'grid',
				store: store,
				anchor: '0, 0',
				border: false,
				loadMask: true,
				columns: [
					{
						header   : 'Kategorie',
//						width    : 160,
						sortable : true,
						dataIndex: 'targetCategoryName'
					},
					{
						header   : 'Feld',
//						width    : 160,
						sortable : true,
						dataIndex: 'targetFieldName'
					},
					{
						header   : 'Quelle',
						sortable : true,
						dataIndex: 'groupId', hidden: true, groupRenderer: function(v, unused, r) {
							return r.get('groupName') + ' (' + v + ')';
						}
					},
					{
						xtype: 'actioncolumn',
						width: 50,
						items: [{
							icon   : '/bundles/pimcoreadmin/img/flat-color-icons/empty_trash.svg',  // Use a URL in the icon config
							tooltip: 'Löschen',
							handler: function(grid, rowIndex, colIndex) {
								var rec = grid.getStore().getAt(rowIndex);

								Ext.Msg.confirm(t('delete'), t('pim.dataport.bmecat.confirmDeleteMapping'), function(btn) {
									if (btn == 'yes') {
										grid.getEl().mask();
										Ext.Ajax.request({
											url: "/admin/BlackbitPim/Bmecat/delete-field-mapping",
											method: 'post',
											params: {
												id: rec.get('id'),
												fieldCollection: rec.get('fieldCollection'),
												field: rec.get('field'),
												locale: rec.get('locale')
											},
											success: function(response) {
												grid.getEl().unmask();
												response = Ext.decode(response.responseText);

												if (!(response && response.success)) {
													pimcore.helpers.showNotification(t("error"), t(response.errorMessage || 'pim.dataport.bmecat.deleteMappingError'), "error");
												}

												grid.getStore().load({
													params: idParams
												});

												if (Ext.isFunction(cb)) {
													cb(null, rec.get('targetCategoryId'));
												}
											},
											failure: function(response) {
												grid.getEl().unmask();
												response = Ext.decode(response.responseText);

												var error = t(response.errorMessage || 'pim.dataport.bmecat.deleteMappingError');
												pimcore.helpers.showNotification(t("error"), error, "error");

												grid.getStore().load({
													params: idParams
												});

												if (Ext.isFunction(cb)) {
													cb(new Error(error, rec.get('targetCategoryId')));
												}
											}
										});
									}
								});
							}
						}]
					}
				],
				stripeRows: true,
				view: new Ext.grid.GroupingView({
					forceFit: true,
					emptyText: t('pim.dataport.bmecat.noMapping'),
					showGroupName: false,
					groupTextTpl: '{text}'
				}),
				listeners: {
					afterrender: function() {
						store.load({
							params: idParams
						});
					}
				}
			}]
		});
	}
});