<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

namespace Blackbit\PimBundle\lib\Pim\Shop;

use Blackbit\PimBundle\lib\Pim\Shop\Helper\Basic;
use Blackbit\PimBundle\lib\Pim\Shop\Helper\HelperInterface;
use Blackbit\PimBundle\model\ShopConfig;

/**
 *
 *
 * @author Dennis Korbginski <dennis.korbginski@blackbit.de>
 * @copyright Blackbit neue Medien GmbH, http://www.blackbit.de/
 */
class Helper {
	const PIM_PRICECALCULATOR = "calculator";

	/**
	 * @var HelperInterface
	 */
	private static $customHelper;

	/**
	 * @return HelperInterface
	 */
	private static function getHelper() {
		if (self::$customHelper === null) {
			$helperClass = "Website_Pim_Shop_Helper";

			if (@class_exists($helperClass) && in_array("Pim_Shop_Helper_Interface", class_implements($helperClass))) {
				self::$customHelper = new $helperClass;
			} else {
				self::$customHelper = new Basic();
			}
		}

		return self::$customHelper;
	}


	private static function getConfig($key) {
		$configTable = new ShopConfig();
		return $configTable->find(['`key` = ?' => $key]);
	}

	/**
	 * @return Pricecalculator
	 */
	public static function getPricecalculator() {
		$calculatorClass = Helper::getConfig(Helper::PIM_PRICECALCULATOR);

		if (!empty($calculatorClass)) {
			return new $calculatorClass->value;
		}

		return null;
	}

	public static function checkAccess($entity, array $params = array()) {
		return self::getHelper()->checkAccess($entity, $params);
	}

	public static function afterImport($dataportId) {
		return self::getHelper()->afterImport($dataportId);
	}
}
