<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

namespace Blackbit\PimBundle\EventListener;

use Blackbit\PimBundle\Tools\Installer;
use Pimcore\Db;
use Pimcore\Event\System\MaintenanceEvent;
use Pimcore\Logger;

class ImportStatusListener
{
    /**
     * @throws \Doctrine\DBAL\DBALException
     * @throws \Symfony\Component\DependencyInjection\Exception\InvalidArgumentException
     */
    public function maintenance(MaintenanceEvent $event)
    {
        $cleanupInterval = (int)\Pimcore::getContainer()->getParameter('blackbit_pim.importstatus.cleanup_interval');

        if($cleanupInterval <= 0) {
            return;
        }

        $db = Db::get();
        $db->exec('DELETE FROM `'. Installer::TABLE_IMPORTSTATUS . '` WHERE `lastUpdate` <= NOW()-INTERVAL ' . $cleanupInterval . ' DAY');

        Logger::info('Import status table cleaned up');
    }
}
