<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

namespace Blackbit\PimBundle\model;

use Blackbit\PimBundle\Tools\Installer;
use Blackbit\PimBundle\model\PimcoreDbRepository;
use Doctrine\DBAL\Query\QueryBuilder;

class RawItem extends PimcoreDbRepository
{
    protected function getTableName(): string
    {
        return Installer::TABLE_RAWITEM;
    }

    public function findByFieldValue($dataportId, $fieldNo, $fieldValue) {
        $queryBuilder = new QueryBuilder($this->connection);
        $query = $queryBuilder->select('item.*')->from($this->getTableName(), 'item')->where('item.dataportId = '.$this->connection->quote($dataportId));
        
        foreach((array)$fieldNo as $index => $fieldNumber) {
            $query->join('item', Installer::TABLE_RAWITEMDATA, 'data' . $index, 'item.id = data' . $index . '.rawItemId');
        }

        foreach((array)$fieldNo as $index => $fieldNumber) {
            $query->andWhere('data'.$index.'.fieldNo = '.$this->connection->quote($fieldNumber));
        }
        foreach((array)$fieldValue as $index => $fieldValueItem) {
            $query->andWhere('data'.$index.'.value = '.$this->connection->quote($fieldValueItem));
        }

        $query->groupBy('item.id');

        return $this->connection->fetchAll($query->getSQL());
    }

    public function findByHash($dataportId, $hash) {
        $queryBuilder = new QueryBuilder($this->connection);
        $query = $queryBuilder->select('id')->from($this->getTableName())->where('dataportId = ? AND hash=?');

        return $this->connection->fetchColumn($query->getSQL(), [$dataportId, $hash]);
    }
}
