<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

namespace Blackbit\PimBundle;

use Blackbit\PimBundle\lib\Pim\Logger;
use Blackbit\PimBundle\Tools\Installer;
use Pimcore\Db;
use Pimcore\Extension\Bundle\AbstractPimcoreBundle;
use Pimcore\Extension\Bundle\Traits\PackageVersionTrait;

class BlackbitPimBundle extends AbstractPimcoreBundle
{
    use PackageVersionTrait {
        getVersion as protected getComposerVersion;
    }

    public function getInstaller()
    {
        return new Installer(new Logger());
    }

    public function getJsPaths()
    {
        return [
            '/bundles/blackbitpim/js/ImportConfig.js',
            '/bundles/blackbitpim/js/plugin.js',
            '/bundles/blackbitpim/js/MappingConfig.js',
            '/bundles/blackbitpim/js/VariantConfig.js',
            '/bundles/blackbitpim/js/components/BmecatImport.js',
            '/bundles/blackbitpim/js/components/VariantPanel.js',
            '/bundles/blackbitpim/js/components/VariantStatusPanel.js',
            '/bundles/blackbitpim/js/components/DataportPanel.js',
            '/bundles/blackbitpim/js/components/DataportPreview.js',
            '/bundles/blackbitpim/js/components/ManualImport.js',
            '/bundles/blackbitpim/js/components/MappingPanel.js'
        ];
    }

    public function getCssPaths()
    {
        return [
            '/bundles/blackbitpim/css/pim.css'
        ];
    }

    /**
     * Returns the composer package name used to resolve the version
     *
     * @return string
     */
    protected function getComposerPackageName(): string
    {
        return 'blackbit/Pim';
    }

    public function getVersion()
    {
        try {
            return $this->getComposerVersion();
        } catch (\Exception $e) {
            return 'unknown';
        }
    }


}
