<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

namespace Blackbit\PimBundle\Migrations;

use Blackbit\PimBundle\Tools\Installer;
use Doctrine\DBAL\Schema\Schema;
use Doctrine\DBAL\Types\Type;
use Pimcore\Db;
use Pimcore\Migrations\Migration\AbstractPimcoreMigration;

class Version20170608151600 extends AbstractPimcoreMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $fieldMapping = $schema->getTable(Installer::TABLE_FIELDMAPPING);

        if (!$fieldMapping->hasColumn('brickName')) {
            $fieldMapping->addColumn('brickName', Type::STRING, [
                'notnull' => false,
                'default' => null
            ]);
        }

        if (!$fieldMapping->hasColumn('targetBrickField')) {
            $fieldMapping->addColumn('targetBrickField', Type::STRING, [
                'notnull' => false,
                'default' => null
            ]);
        }
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        $fieldMapping = $schema->getTable(Installer::TABLE_FIELDMAPPING);
        $fieldMapping->dropColumn('brickName');
        $fieldMapping->dropColumn('targetBrickField');
    }
}
