<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

namespace Blackbit\PimBundle\Migrations;

use Blackbit\PimBundle\model\Dataport;
use Blackbit\PimBundle\Tools\Installer;
use Doctrine\DBAL\Schema\Column;
use Doctrine\DBAL\Schema\Schema;
use Doctrine\DBAL\Types\Type;
use Pimcore\Db;
use Pimcore\Migrations\Migration\AbstractPimcoreMigration;

class Version20181126122530 extends AbstractPimcoreMigration
{
    /**
     * @param Schema $schema
     */
    public function up(Schema $schema)
    {
        $rawItemField = $schema->getTable(Installer::TABLE_RAWITEMFIELD);
        $rawItemField->addColumn('priority', Type::SMALLINT, [
            'default' => 0,
            'notnull' => true
        ]);
        $rawItemField->addIndex(['dataportId','priority'], 'index_rawItemField_dataportId_priority');

        $rawItem = $schema->getTable(Installer::TABLE_RAWITEM);
        $rawItem->addColumn('priority', Type::STRING, [
            'default' => '',
            'notnull' => true
        ]);
        $rawItem->addIndex(['dataportId','priority'], 'index_rawItem_dataportId_priority');
    }

    /**
     * @param Schema $schema
     */
    public function down(Schema $schema)
    {
        $rawItemField = $schema->getTable(Installer::TABLE_RAWITEMFIELD);
        $rawItemField->dropIndex('index_rawItemField_dataportId_priority');
        $rawItemField->dropColumn('priority');

        $rawItem = $schema->getTable(Installer::TABLE_RAWITEM);
        $rawItem->dropIndex('index_rawItem_dataportId_priority');
        $rawItem->dropColumn('priority');
    }
}
