<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
class Pim_Transfer {
	public function import($language = 0) {
		$source = mysql_connect('localhost', 'viani', 'viani');
		mysql_select_db('viani', $source);
		$charsetchange = mysql_set_charset('UTF8', $source);

		// Diese Sprache importieren

		$zendLang = $german = new Zend_Locale("de");
		if ($language != 0) {
			$zendLang = new Zend_Locale("en");
		}

		$columnMapping = array(
			0 => 'sz_ShortText',
			1 => 'n_Value',
			2 => 'd_Value',
			3 => 'ts_Value',
			4 => 'lc_LongText',
			6 => 'lc_LongText',
		);

		$attributeMapping = array(
			30 => "internetname1", /* Internetname 1 */
			31 => "internetname2", /* Internetname 2 */
			34 => "shorttext", /* Artikeltext kurz */
			37 => "info", /* Info */
			42 => "measurement", /* MaÃŸangabe */
			43 => "image1", /* Artikelbild 1 */
			47 => "image2", /* Artikelbild 2 */
			49 => "image3", /* Artikelbild 3 */
			51 => "image4", /* Artikelbild 4 */
			53 => "image5", /* Artikelbild 5 */
			55 => "unit", /* Bezeichnung Einheit */
			56 => "minsupply", /* Minimalbestand */
			57 => "preorder", /* Vorbestellung */
			58 => "priceByWeight", /* Preis nach Gewicht */
			60 => "stock", /* Lagerbestand */
			61 => "grossWeightPerUnit", /* Bruttogewicht/Preiseinheit */
			62 => "islocked", /* gesperrt */
			63 => "availabilty", /* VerfÃ¼gbarkeit */
			64 => "comparisonPriceUnit", /* Vergleichspreis-Einheit */
			65 => "drainedWeight", /* Abtropfgewicht */
			66 => "comparisonPriceValue", /* Vergleichspreis-Wert */
			67 => "annotation", /* Bemerkung */
			75 => "eancode", /* EAN-Code */
			77 => "stPrice", /* ST-Preis */
			78 => "ve", /* VE */
			79 => "vePrice", /* VE-Preis_Alt */
			80 => "me", /* ME */
			81 => "mePrice", /* ME-Preis */
			82 => "recommendedRetailPrice", /* UVP */
			85 => "bio", /* Bio */
			86 => "new", /* Neu */
			87 => "pricelistName1", /* Preislistenname 1 */
			89 => "pricelistName2", /* Preislistenname 2 */
			91 => "indexValue", /* Index */
			92 => "pricelist", /* Preisliste */
			93 => "longtext", /* Artikeltext lang */
			94 => "netWeight", /* Nettogewicht */
			95 => "itemPrice", /* ArtikelVKPreis */
			96 => "usageDate1", /* DatumVerwendet[1] */
			97 => "itemPriceVe", /* VE-Preis */
			98 => "usageDate2", /* DatumVerwendet[2] */
			99 => "itemPriceMe", /* ArtikelVKPreisME */
			100 => "usageDate3", /* DatumVerwendet[3] */
			101 => "importCatalog", /* importKatalog */
			102 => "discount", /* Internet-Rabatt */
			103 => "ingredients", /* Zutaten */

			/* Ehemalige Produktattribute */
			32 => "originalManufacturer",
			33 => "origin", /* Herkunft */
			39 => "description", /* Produkttext kurz */
			68 => "annotation", /* Bemerkung */
			72 => "manufacturerUrl", /* URL Herstellerportrait */
			73 => "catalog", /* Katalog Kapitel, Seite */
			74 => "countrycode", /* Landkürzel */
			76 => "country", /* Land */
			84 => "region", /* Region */

		);


		$availableItems = new Object_Item_List();
//		$availableItems = Object_Item::getByErpcode("1100");

		$i = 0;
		foreach ($availableItems as $item) {
			$i++;
//echo "\n\n" . $vianiItem['sz_ERPCode'] . "\n";
//echo "--------------------------------------------\n\n";
			if ($i % 100 == 0) {
				Pimcore::collectGarbage();
			}

			$erpcode = $item->getErpcode();

			$vianiItems = $this->q("SELECT sz_ERPCode, n_ProductId FROM Item WHERE sz_ERPCode = '{$erpcode}'", $source);


//			$item = null;
//			$items = Object_Item::getByErpcode($erpcode);
//
//			if ($items && count($items) > 0) {
//				$item = $items->current();
//			}

			echo "\n\nItem {$erpcode}\n---------------\n";

			if (empty($vianiItems)) {
				echo "Item {$erpcode} nicht gefunden\n";
				continue;
			}

			if (count($vianiItems) > 1) {
				echo "Zu viele Artikel mit Erp-Code {$erpcode}\n";
				continue;
			}

			$values = $this->q("
				SELECT v.id, a.id as attribute, a.n_Type, v.n_Value, v.d_Value, v.ts_Value, t.sz_ShortText, t.lc_LongText
				FROM Item i, Attribute a, Value v LEFT JOIN ShopText t ON (t.n_TextId = v.n_ValueTextId AND t.n_LanguageId = {$language})
				WHERE i.id = v.n_ItemProductId
				AND a.id = v.n_AttributeId
				/*AND a.b_IsProductAttribute = 0*/
				AND i.sz_ERPCode = '{$erpcode}'
				ORDER BY i.id
			", $source);

			$productValues = $this->q("
				SELECT v.id, a.id as attribute, a.n_Type, v.n_Value, v.d_Value, v.ts_Value, t.sz_ShortText, t.lc_LongText
				FROM Item i, Product p, Attribute a, Value v LEFT JOIN ShopText t ON (t.n_TextId = v.n_ValueTextId AND t.n_LanguageId = {$language})
				WHERE i.n_ProductId = p.id
				AND p.id = v.n_ItemProductId
				AND a.id = v.n_AttributeId
				/*AND a.b_IsProductAttribute = 0*/
				AND i.sz_ERPCode = '{$erpcode}'
				ORDER BY i.id
			", $source);

			$values = array_merge($values, $productValues);

			for ($i = 0; $i < count($values); $i++) {
				$value = $values[$i];
				$type = $value['n_Type'];

				if (!array_key_exists($type, $columnMapping)) {
					echo "Unbekannter Typ {$type} für Value {$value['id']}\n";
					continue;
				}

				$attributeId = intval($value['attribute']);
				if (!array_key_exists($attributeId, $attributeMapping)) {
					continue;
				}

				$data = $value[$columnMapping[$type]];

				switch ($type) {
					case 3:
						// Timestamp: 2012-10-15 00:00:00
						$date = DateTime::createFromFormat("Y-m-d H:i:s", $data);
						if ($date) {
							$data = new Zend_Date($date->getTimestamp());
						}
						break;
				}

				switch ($attributeId) {
					case 62:
						if ("Nein" == $data || "No" == $data) {
							$data = 0;
						} else {
							$data = 1;
						}
						break;
					case 85:
					case 86:
						if ("Ja" == $data || "Yes" == $data) {
							$data = 1;
						} else {
							$data = 0;
						}
						break;
					case 37:
						$listValues = $this->q("select idValue, t.sz_ShortText
							from selectedValueListEntry s, valueListEntry e, ShopText t
							WHERE s.idValueListEntry = e.idValueListEntry
							AND t.n_TextId = e.idTextLabel
							AND t.n_LanguageId = 0
							AND idValue = {$value['id']}", $source);

						if (is_array($listValues)) {
							$entries = array();
							foreach ($listValues as $val) {
								$entries[] = strtolower($val['sz_ShortText']);
							}
							$data = $entries;
						}
						break;
					case 103:
						// Zutaten
						$ingredients = json_decode("[" . $data . "]");

						$data = array();
						foreach ($ingredients as $igrendient) {
							$tmp = array(
								'name' => $igrendient->column1,
								'percentage' => intval($igrendient->column2),
								'allergen' => $igrendient->column3 == "Nein" || $igrendient->column3 == "No" ? 0 : 1,
							);

							$data[] = $tmp;
						}

						$data = new Object_Data_FlexibleTable($data);

//						var_dump($data);

						break;
				}
/*
				vprintf("%3d => %s\n", array(
					$attributeId,
					$data
				));
*/


				$fieldname = $attributeMapping[$attributeId];
				$setter = "set" . ucfirst($fieldname);

				try {
					$method = new ReflectionMethod($item, $setter);
					$params = $method->getParameters();

					if ($method->getNumberOfParameters() > 1 && $params[1]->name == "language") {
						$method->invoke($item, $data, $zendLang);
					} else {
						$method->invoke($item, $data);
					}
//					echo $setter . "($data)\n";

				} catch (ReflectionException $re) {
					var_dump($re);
				}
			}

			if ($language != 0) {
				$name = $item->getName($german);
				$manufacturer = $item->getManufacturer($german);
				$item->setName($name, $zendLang);
				$item->setManufacturer($manufacturer, $zendLang);
			}

			try {
				$item->save();
			} catch (Exception $e) {
				echo "Fehler beim Speichern: {$e}\n";
			}
		}


		mysql_close($source);
	}


	private function q($query,$source = null,$assoc=1) {
		$r = @mysql_query($query, $source);
		if( mysql_errno() ) {
			$error = 'MYSQL ERROR #'.mysql_errno().' : <small>' . mysql_error(). '</small><br><VAR>' . $query . '</VAR>';
			echo($error); return FALSE;
		}
		if( strtolower(substr(trim($query),0,6)) != 'select' ) return array(mysql_affected_rows(),mysql_insert_id());
		$count = @mysql_num_rows($r);
		if( !$count ) return 0;

		$all = array();
		for( $i = 0; $i < $count; $i++ ) {
			if( $assoc ) $f = mysql_fetch_assoc($r);
			else $f = mysql_fetch_row($r);
			$all[] = $f;
		}
		mysql_free_result($r);
		return $all;
	}
}
