<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Blackbit\PimBundle\lib\Pim\Variant\Generator;

/**
 * Class GeneratorFactory
 *
 * @package blackbit\PimBundle\lib\Pim\Variant\Generator
 */
class GeneratorFactory
{
    /**
     * @var ObjectGenerator
     */
    private $objectGenerator;
    /**
     * @var TemplateGenerator
     */
    private $templateGenerator;

    /**
     * GeneratorFactory constructor.
     *
     * @param ObjectGenerator   $objectGenerator
     * @param TemplateGenerator $templateGenerator
     */
    public function __construct(
        ObjectGenerator $objectGenerator,
        TemplateGenerator $templateGenerator
    ) {
        $this->objectGenerator = $objectGenerator;
        $this->templateGenerator = $templateGenerator;
    }

    /**
     * @return GeneratorInterface|TemplateGenerator
     */
    public function template()
    {
        return $this->templateGenerator;
    }

    /**
     * @return GeneratorInterface|ObjectGenerator
     */
    public function object()
    {
        return $this->objectGenerator;
    }

    /**
     * @param $type
     *
     * @return GeneratorInterface
     * @throws \Exception
     */
    public function getGeneratorByType($type)
    {
        if (!method_exists($this, strtolower($type))) {
            throw new \Exception('Generator ' . $type . ' not implemented');
        }

        return $this->{strtolower($type)}();
    }
}
