<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Blackbit\PimBundle\lib\Pim\Variant\Model;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class TreeItem
 *
 * @package blackbit\PimBundle\lib\Pim\Variant\Model
 */
class TreeItem
{
    /**
     * @var int
     */
    private $id;
    /**
     * @var string
     */
    private $text;
    /**
     * @var string
     */
    private $name;
    /**
     * @var string
     */
    private $iconCls;
    /**
     * @var boolean
     */
    private $leaf;
    /**
     * @var boolean
     */
    private $root = false;
    /**
     * @var boolean
     */
    private $visible = true;
    /**
     * @var bool
     */
    private $expanded = false;
    /**
     * @var int
     */
    private $parentId;
    /**
     * @var string
     */
    private $type;
    /**
     * @var ArrayCollection|TreeItem[]
     */
    private $children;

    /**
     * TreeItem constructor.
     */
    public function __construct()
    {
        $this->children = new ArrayCollection();
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     *
     * @return TreeItem
     */
    public function setId(int $id): TreeItem
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string
     */
    public function getText(): string
    {
        return $this->text;
    }

    /**
     * @param string $text
     *
     * @return TreeItem
     */
    public function setText(string $text): TreeItem
    {
        $this->text = $text;

        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return TreeItem
     */
    public function setName(string $name): TreeItem
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getIconCls(): string
    {
        return $this->iconCls;
    }

    /**
     * @param string $iconCls
     *
     * @return TreeItem
     */
    public function setIconCls(string $iconCls): TreeItem
    {
        $this->iconCls = $iconCls;

        return $this;
    }

    /**
     * @return bool
     */
    public function isLeaf(): bool
    {
        return $this->leaf;
    }

    /**
     * @param bool $leaf
     *
     * @return TreeItem
     */
    public function setLeaf(bool $leaf): TreeItem
    {
        $this->leaf = $leaf;

        return $this;
    }

    /**
     * @return bool
     */
    public function isRoot(): bool
    {
        return $this->root;
    }

    /**
     * @param bool $root
     *
     * @return TreeItem
     */
    public function setRoot(bool $root): TreeItem
    {
        $this->root = $root;

        return $this;
    }

    /**
     * @return bool
     */
    public function isVisible(): bool
    {
        return $this->visible;
    }

    /**
     * @param bool $visible
     *
     * @return TreeItem
     */
    public function setVisible(bool $visible): TreeItem
    {
        $this->visible = $visible;

        return $this;
    }

    /**
     * @return bool
     */
    public function isExpanded(): bool
    {
        return $this->expanded;
    }

    /**
     * @param bool $expanded
     *
     * @return TreeItem
     */
    public function setExpanded(bool $expanded): TreeItem
    {
        $this->expanded = $expanded;

        return $this;
    }

    /**
     * @return int
     */
    public function getParentId(): int
    {
        return $this->parentId;
    }

    /**
     * @param int $parentId
     *
     * @return TreeItem
     */
    public function setParentId(int $parentId): TreeItem
    {
        $this->parentId = $parentId;

        return $this;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     *
     * @return TreeItem
     */
    public function setType(string $type): TreeItem
    {
        $this->type = $type;

        return $this;
    }

    /**
     * @param TreeItem $child
     */
    public function addChild(TreeItem $child)
    {
        $this->children->add($child);
    }

    /**
     * @return array
     */
    public function toArray()
    {
        $array = get_object_vars($this);
        unset($array['children']);
        foreach ($this->children as $childTreeItem) {
            $array['children'][] = $childTreeItem->toArray();
        }

        return $array;
    }
}
