<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Blackbit\PimBundle\lib\Pim\Variant;

use Blackbit\PimBundle\lib\Pim\Item\Importer;
use Blackbit\PimBundle\model\ResourceFactory;
use Pimcore\Model\DataObject\AbstractObject;

/**
 * Class VariantMapper
 *
 * @package blackbit\PimBundle\lib\Pim\Variant
 */
class VariantMapper
{
    /**
     * @var Importer
     */
    private $importer;
    /**
     * @var
     */
    private $resourceFactory;

    /**
     * VariantMapper constructor.
     *
     * @param Importer        $importer
     * @param ResourceFactory $resourceFactory
     */
    public function __construct(
        Importer $importer,
        ResourceFactory $resourceFactory
    ) {
        $this->importer = $importer;
        $this->resourceFactory = $resourceFactory;
    }

    /**
     * @param integer        $variantId
     * @param array          $sourceConfig
     * @param array          $targetConfig
     * @param array          $targetItem
     * @param AbstractObject $object
     * @param string         $name
     */
    public function applyMapping($variantId, $sourceConfig, $targetConfig, $targetItem, $object, $name)
    {
        $this->importer->mapData(
            $object,
            ['id' => $object->getId(), 'name' => $name],
            $targetItem,
            $this->resourceFactory->fieldMapping()->find(['dataportId = ?' => $variantId]),
            $sourceConfig,
            [],
            $targetConfig,
            1
        );
    }
}
