<?php
/**
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

namespace Blackbit\PimBundle\Command;

use Blackbit\PimBundle\model\RawItem;
use Pimcore\Console\AbstractCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class DeleteRawdataCommand extends AbstractCommand
{
    protected function configure()
    {
        $this
            ->setName('import:delete-rawdata')
            ->setDescription('Removes all rawdata entries')
            ->addOption('dataport', null, InputOption::VALUE_OPTIONAL, 'ID of a dataport')
//            ->addOption('since', null, InputOption::VALUE_OPTIONAL, 'IF this option is given, only raw data entries older than this value (in hours) will be removed')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $dataportId = $input->getOption('dataport');

        $deleteCondition = [];

        if (!empty($dataportId)) {
            $deleteCondition['dataportId'] = $dataportId;
            $output->writeln('Deleting rawdata of dataport ' . $dataportId);
        } else {
            $output->writeln('Deleting all rawdata');
        }

        $repository = new RawItem();
        $result = $repository->deleteWhere($deleteCondition);

        $output->writeln($result . ' entries deleted.');
    }
}