/*
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/**
 * Konfiguration des Datentyps im Klasseneditor
 */

pimcore.registerNS("pimcore.object.classes.data.flexibleTable");
pimcore.object.classes.data.flexibleTable = Class.create(pimcore.object.classes.data.data, {

    type: "flexibleTable",
    /**
     * define where this datatype is allowed
     */
    allowIn: {
        object: true,
        objectbrick: true,
        fieldcollection: true,
        localizedfield: true
    },

    initialize: function (treeNode, initData) {
        this.type = "flexibleTable";

        this.initData(initData);

        // overwrite default settings
        this.availableSettingsFields = ["name","title","tooltip","mandatory","noteditable","invisible","style"];

        this.treeNode = treeNode;
    },

    getGroup: function () {
            return "structured";
    },

    getTypeName: function () {
        return t("flexibleTable");
    },

    getIconClass: function () {
        return "pimcore_icon_structuredTable";
    },

    getLayout: function ($super) {
        this.grids = {};
        this.stores = {};

        $super();

        this.specificPanel.removeAll();
        this.specificPanel.add([
            {
                xtype: "spinnerfield",
                fieldLabel: t("width"),
                name: "width",
                value: this.datax.width
            },
            {
                xtype: "spinnerfield",
                fieldLabel: t("height"),
                name: "height",
                value: this.datax.height
            },
            {
                xtype: "spinnerfield",
                fieldLabel: t("label_width"),
                name: "labelWidth",
                value: this.datax.labelWidth
            },
            this.getGrid("cols", this.datax.cols, true)
        ]);

        return this.layout;
    },


    getGrid: function (title, data, hasType) {

        var fields = [
           'position',
           'key',
           'label',
           'type',
           'width'
        ];
        
        this.stores[title] = new Ext.data.JsonStore({
            autoDestroy: false,
            autoSave: false,
            idIndex: 1,
            fields: fields
        });

        if(!data || data.length < 1) {
            var d = { position: 1, key: "col1", label: "Column 1", type: "number"};
            data = [d];
        }

        if(data) {
            this.stores[title].loadData(data);
        }

        var keyTextField = new Ext.form.TextField({
            //validationEvent: false,
            validator: function(value) {
                value = trim(value);
                var regresult = value.match(/[a-zA-Z0-9_]+/);

                if (value.length > 1 && regresult == value && in_array(value.toLowerCase(), ["id","key","path","type","index","classname","creationdate","userowner","value","class","list","fullpath","childs","values","cachetag","cachetags","parent","published","valuefromparent","userpermissions","dependencies","modificationdate","usermodification","byid","bypath","data","versions","properties","permissions","permissionsforuser","childamount","apipluginbroker","resource","parentClass","definition","locked","language"]) == false) {
                    return true; 
                } else {
                    return t("flexibleTable_invalid_key");
                }
            }
        });


        var typesColumns = [
            {header: t("position"), width: 10, sortable: true, dataIndex: 'position', editor: new Ext.form.NumberField({})},
            {header: t("key"), width: 50, sortable: true, dataIndex: 'key', editor: keyTextField},
            {header: t("label"), width: 150, sortable: true, dataIndex: 'label', editor: new Ext.form.TextField({})}
        ];

		// Datatypes
		var types = {
			number: t("flexibleTable_type_number"),
			text: t("flexibleTable_type_text"),
			bool: t("flexibleTable_type_bool")
		};

		var typeComboBox = new Ext.form.ComboBox({
			triggerAction: 'all',
			allowBlank: false,
			lazyRender: true,
			forceSelection: true,
			lazyInit: false,
			editable: false,
			mode: 'local',
			store: new Ext.data.ArrayStore({
				id: 'value',
				fields: [
					'value',
					'label'
				],
				data: [['number', types.number], ['text', types.text], ['bool', types.bool]]
			}),
			valueField: 'value',
			displayField: 'label'
		});

		typesColumns.push({header: t("type"), width: 50, sortable: true, dataIndex: 'type', editor: typeComboBox, renderer: function(value) {
			return types[value];
		}});

		typesColumns.push({header: t("width"), width: 30, sortable: true, dataIndex: 'width', editor: new Ext.form.NumberField({})});

        this.grids[title] = new Ext.grid.GridPanel({
            title: t(title),
            autoScroll: true,
            autoDestroy: false,
            store: this.stores[title],
            height: 200,
            columns : typesColumns,
            sm: Ext.create('Ext.selection.RowModel', {}),
            columnLines: true,
            name: title,
            tbar: [
                {
                    text: t('add'),
                    handler: this.onAdd.bind(this, this.stores[title]),
                    iconCls: "pimcore_icon_add"
                },
                '-',
                {
                    text: t('delete'),
                    handler: this.onDelete.bind(this, this.stores[title], title),
                    iconCls: "pimcore_icon_delete"
                },
                '-'
            ],
            viewConfig: {
                forceFit: true
            }
        });

        return this.grids[title];
    },


    onAdd: function (store, btn, ev) {
        var u = new store.recordType();
		u.data.type = "text";
        u.data.position = store.getCount() + 1;
        u.data.key = "name";
        store.add(u);
    },

    onDelete: function (store, title) {
        if(store.getCount() > 1) {
            var rec = this.grids[title].getSelectionModel().getSelected();
            if (!rec) {
                return false;
            }
            store.remove(rec);
        }
    },

    getData: function () {
        if(this.grids) {
            var cols = [];
            this.stores.cols.each(function(rec) {
                cols.push(rec.data);
                rec.commit();
            });
            this.datax.cols = cols;
        }

        return this.datax;
    }

});
