/*
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

pimcore.registerNS("pimcore.plugin.Pim.MappingConfig");
pimcore.plugin.Pim.MappingConfig = Class.create({

    tree: null,
    mappingContainer: null,

    initialize: function () {
        var tabPanel = Ext.getCmp("pimcore_panel_tabs");
        var existingTab = Ext.getCmp('panel_pim_mappingconfig');
        if(existingTab) {
            tabPanel.setActiveItem('panel_pim_mappingconfig');
            return existingTab;
        }

        this.initTreeModel();

        // create the holding panel
        var panel = Ext.create('Ext.Panel', {
            id: "panel_pim_mappingconfig",
            title: t('pim.mapping_config'),
            iconCls: "pimcore_icon_settings",
            border: false,
            layout: "border",
            closable: true,
            items: [this.getDataportTree(), this.getMappingContainer()]
        });

        // find the main tabpanel and add ours
        tabPanel.add(panel);
        tabPanel.setActiveItem(panel.id);

        // show the panels by refreshing
        pimcore.layout.refresh();
    },

    getDataportTree: function () {
        if (!this.tree) {
            this.tree = Ext.create('Ext.tree.Panel', {
                id: "Pim_dataport_tree_mapping",
                region: "west",
                collapsible: false,
                useArrows: true,
                autoScroll: true,
                animate: true,
                containerScroll: true,
                border: true,
                width: 350,
                split: true,

                root: {
                    nodeType: 'async',
                    id: '0'
                },

                rootVisible: false,
                lines: false,
                store: this.dataStore,

                viewConfig: {
                    plugins: {
                        ptype: 'treeviewdragdrop',
                        enableDrag: true,
                        enableDrop: false,
                        ddGroup: 'rawitem'
                    },
                    preserveScrollOnRefresh:true,
                    preserveScrollOnReload:true
                },

                tbar: {
                    items: [
                        {
                            iconCls: "pimcore_icon_reload",
                            handler: function () {
                                this.reloadTree();
                            }.bind(this)
                        }
                    ]
                }
            });

            this.tree.on('render', function () {
                this.getRootNode().expand();
            });


            this.tree.on('itemclick', function (sm, node, index) {
                var dataportNode = node;
                this.id = dataportNode.id;
                this.text = dataportNode.data.text;
                if (node.id.substr(0,1) === 'd') {
                    this.id = node.parentNode.id;
                    this.text = node.parentNode.data.text;
                }

                this.onTreeNodeClick();
            }.bind(this))
        }
        return this.tree;
    },

    initTreeModel: function () {
        this.dataportModel = Ext.define('DataPortModel', {
            extend: 'Ext.data.Model',
            fields: [
                {name: 'index', type: 'int', defaultValue: -1, persist: true},
                {name: 'id', type: 'string'},
                {name: 'name', type: 'string'},
                {name: 'iconCls', type: 'string', defaultValue: 'pimcore_icon_class'},
                {name: 'expandable', type: 'bool', defaultValue: true, persist: true, convert: null},
                {name: 'allowDrop', type: 'boolean', defaultValue: false, persist: false, convert: null},

            ],
            proxy: {
                type: 'ajax',
                api: {
                    create: 'createDataUrl',
                    read: '/admin/BlackbitPim/mappingconfig/get-dataports',
                    update: 'updateDataUrl',
                    destroy: 'destroyDataUrl'
                }
            }
        });

        this.dataStore = Ext.create('Ext.data.TreeStore', {
            model: 'DataPortModel',
            root: {
                name: 'Data',
                expanded: true
            }
        });
    },

    expandDataportNode: function(tab) {
        if (tab) {
            var dataportId = tab.dataportId;
            var tree = this.tree;
            this.tree.getRootNode().cascade(function () {
                if (this.id === dataportId) {
                    this.expand();
                    tree.setSelection(this);
                } else if(this.id > 0) {
                    this.collapse();
                }
            });
        }
    },

    getMappingContainer: function () {
        if (!this.mappingContainer) {
            this.mappingContainer = new Ext.TabPanel({
                region: "center",
                listeners: {
                    'tabchange': function (tabpanel, tab) {
                        this.expandDataportNode(tab);
                    }.bind(this),
                    'add': function (tabpanel, tab) {
                        this.expandDataportNode(tab);
                    }.bind(this)
                }
            });
        }

        return this.mappingContainer;
    },

    reloadTree: function () {
        if (this.tree) {
            this.dataStore.getRoot().removeAll();
            this.dataStore.load();
        }
    },

    getOpenPanels: function (dataportId) {
        var container = this.getMappingContainer();

        var panels = [];
        var panel = container.down('[dataportId='+dataportId+']');
        if(panel) {
            panels.push(panel);
        }

        return panels;
    },

    onTreeNodeClick: function () {
        if (this.id > 0) {
            var dataportId = this.id;
            var container = this;//this.attributes.reference;
            var existingPanels = container.getOpenPanels(dataportId);

            if (existingPanels.length > 0) {
                existingPanels[0].show();
            } else {
                Ext.Ajax.request({
                    url: "/admin/BlackbitPim/mappingconfig/rawdata-fields/" + dataportId,
                    params: {
                        dataportId: dataportId
                    },
                    success: function (response) {
                         try {
                            response = Ext.decode(response.responseText);
                            if (response && response.success) {
                                var rawDataFields = response.fields;

                                var mappingPanel = Ext.create('pimcore.plugin.Pim.MappingPanel', {
                                    dataportId: dataportId,
                                    title: this.text,
                                    rawDataFields: rawDataFields
                                });
                                container.getMappingContainer().add(mappingPanel).show();
                                container.getMappingContainer().updateLayout();
                            }
                        } catch (e) {
                            console.log("ERROR", e);
                        }
                    }.bind(this)
                });
            }

            pimcore.layout.refresh();
        }
    }
});