/*
 * Copyright Blackbit digital Commerce GmbH <info@blackbit.de>
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

pimcore.registerNS("pimcore.plugin.Pim.MappingConfig");


// Ext.require([
//     'pimcore.static6.js.lib.ext.ux.form.SearchField'
// ]);

pimcore.plugin.Pim.MappingPanel = Ext.extend(Ext.grid.Panel, {
    dataportId: null,

    rawDataFields: null,
    features: [{ftype: 'grouping'}],
    layout: {
        type: 'fit',
        align: 'stretch',
        pack: 'start'
    },

    customData: null,
    gridInstance: null,


    //   flex: 1,

//	dataport: null,

    initComponent: function () {
        var mappingPanel = this;

        var store = Ext.create('Ext.data.Store', {
            model: 'MappingConfigModel',
            pageSize: 0,
            remoteFilter: false,
            autoSync: true,
            autoLoad: true,

            proxy: {

                type: 'ajax',

                simpleSortMode: true,

                api: {
                    read: '/admin/BlackbitPim/mappingconfig/get-config/' + mappingPanel.dataportId,
                    create: '/admin/BlackbitPim/mappingconfig/save-config',
                    update: '/admin/BlackbitPim/mappingconfig/save-config'
                },
                reader: {
                    type: 'json',
                    rootProperty: 'mapping',
                    totalProperty: 'totalCount',
                    useSimpleAccessors: false
                },

                writer: {
                    type: 'json',
                    writeAllFields: true,
                    rootProperty: 'mapping',

                    encode: true,
                    transform: {
                        fn: function (data, request) {
                            // console.log("WRITER DATA ", data);
                            request.setParam('dataportId', this.dataportId);
                            request.setParam('omitReturnMapping', '1');

                            if (Ext.isArray(data)) {
                                Ext.Array.each(data, function (value) {
                                    value['attribute.key'] = value.attribute.key;
                                });
                            } else {
                                data['attribute.key'] = data.attribute.key;
                            }

                            return data;

                        },
                        scope: this
                    }


                },
                listeners: {
                    exception: function (proxy, response, operation) {
                        if (operation.getError()) {
                            Ext.MessageBox.show({
                                title: 'REMOTE EXCEPTION',
                                msg: operation.getError(),
                                icon: Ext.MessageBox.ERROR,
                                buttons: Ext.Msg.OK
                            });
                        }
                    }
                }
            },
            listeners: {
                write: function (proxy, operation) {

                    console.log("WRITE");

                    if (gridInstance) {
                        console.log("REFRESH");
                        store.load();
                        gridInstance.getView().refresh();
                    }
                },
                totalcountchange: onStoreSizeChange


            }
        });


        function onStoreSizeChange() {
            console.log("COUNT ", store.getTotalCount());
            //gridInstance.down('#status').update({count: store.getTotalCount()});
        }


        var searchField = Ext.create('Ext.ux.form.SearchField', {
            width: 400,
            fieldLabel: 'Search',
            labelWidth: 50,
            xtype: 'searchfield',
            store: store,
            paramName: 'attributeName'
        });


        Ext.apply(this, {
                activeRecord: null,

                title: mappingPanel.title,
                closable: true,
                reference: this,
                trackMouseOver: true,
                store: store,
                clicksToEdit: 1,
                columnLines: true,
                stripeRows: true,
                //  autoExpandColumn: "pim.importconfig.rawdatafield",

                loadMask: true,
                dockedItems: [{
                    dock: 'top',
                    xtype: 'toolbar',
                    items: [
                        searchField,
                        '->', {
                            xtype: 'component',
                            itemId: 'status',
                            tpl: 'Matching threads: {count}',
                            style: 'margin-right:5px'
                        }
                    ]
                }],

                selModel: {
                    pruneRemoved: false
                },
                multiSelect: true,
                viewConfig: {
                    trackOver: false,
                    emptyText: '<h1 style="margin:20px">No matching results</h1>'
                },


                columns: [
                    {
                        header: 'Attribut',
                        dataIndex: 'attributeName',
                        groupable: false,
                        width: 200

                    },
                    {
                        header: 'Datentyp',
                        dataIndex: 'type',
                        width: 200

                    },
                    {
                        // id: 'pim.importconfig.rawdatafield',
                        header: 'Rohdatenfeld',
                        dataIndex: 'field',
                        width: 200,
                        renderer: function (value) {
                            if (value) {
                                if (this.rawDataFields[value]) {
                                    return value + ': ' + this.rawDataFields[value];
                                } else {
                                    return t('pim.rawdatafield') + ' ' + value;
                                }
                            } else {
                                return "";
                            }
                        }.bind(this)

                    },
                    {
                        header: 'Sprachabhängig',
                        dataIndex: 'localized',
                        width: 'auto',
                        hidden: true,

                        renderer: function (value) {
                            if (value) {
                                return t('pim.true');
                            } else {
                                return t('pim.false');
                            }
                        }
                    },
                    {
                        xtype: 'actioncolumn',
                        width: 100,
                        sortable: true,
                        menuDisabled: true,
                        items: [{
                            tooltip: t('pim.dataport_configpanel'),
                            icon: "/bundles/pimcoreadmin/img/flat-color-icons/services.svg",
                            getClass: function (v, metadata, record) {
                                var settings = record.get('settings');
                                if (settings && settings.calculation && typeof settings.calculation == 'string' && settings.calculation.length > 0) {
                                    metadata.css = 'pim_calculation';
                                }
                                return '';
                            },
                            handler: function (grid, rowIndex) {
                                var record = grid.getStore().getAt(rowIndex);
                                mappingPanel.showSettingsWindow(record);
                            }.bind(this)
                        }, {
                            tooltip: 'Schlüsselattribut',
                            icon: "/bundles/pimcoreadmin/img/flat-color-icons/key.svg",
                            getClass: function (v, metadata, record) {
                                var settings = record.get('settings');
                                if (!settings || !settings.keyMapping) {
                                    return 'x-hidden-display';
                                }
                                return '';
                            },
                            handler: function (grid, rowIndex) {
                                var record = grid.getStore().getAt(rowIndex);
                                mappingPanel.showSettingsWindow(record);
                            }.bind(this)
                        }]
                    },
                    {
                        xtype: 'actioncolumn',
                        width: 100,
                        sortable: true,
                        menuDisabled: true,
                        items: [{
                            tooltip: 'Zuordnung entfernen',
                            icon: "/bundles/pimcoreadmin/img/flat-color-icons/delete.svg",
                            handler: function (grid, rowIndex) {

                                var tempstore = grid.getStore();
                                var record = tempstore.getAt(rowIndex);

                                record.set('field', null);
                            }.bind(this)
                        }]
                    }
                ],


                listeners: {
                    render: function (grid) {
                        grid.dropZone = Ext.create('Ext.dd.DropZone', grid.el, {
                            ddGroup: "rawitem",
                            //      If the mouse is over a grid row, return that node. This is
                            //      provided as the "target" parameter in all "onNodeXXXX" node event handling functions
                            getTargetFromEvent: function (e) {
                                return e.getTarget(grid.getView().rowSelector);
                            },
                            //      On entry into a target node, highlight that node.
                            onNodeEnter: function (target, dd, e, data) {


                                // Ext.fly(target).addClass('my-row-highlight-class');
                            },

                            //      On exit from a target node, unhighlight that node.
                            onNodeOut: function (target, dd, e, data) {
                                ///Ext.fly(target).removeClass('my-row-highlight-class');
                            },

                            //      While over a target node, return the default drop allowed class which
                            //      places a "tick" icon into the drag proxy.
                            onNodeOver: function (target, dd, e, data) {
                                // console.log("data", data);
                                var match = data.records[0].get('id').match(/^d([0-9]+)-field[0-9]+$/);
                                if (match && match[1] == mappingPanel.dataportId) {
                                    return Ext.dd.DropZone.prototype.dropAllowed;
                                } else {
                                    // console.log("DROP NOT ALLOWED");
                                    return Ext.dd.DropZone.prototype.dropNotAllowed;
                                }
                            },
                            onNodeDrop: function (target, dd, e, data) {
                                var r = grid.getView().getRecord(target);
                                var match = data.records[0].get('id').match(/^d[0-9]+-field([0-9]+)$/);
                                //console.log(" match[1] ", grid.store,  match, match[1]);

                                if (match && match[1]) {
                                    r.set('field', match[1]);

                                    gridInstance.getView().refresh();

                                    return true;
                                } else {
                                    return false;
                                }
                            }
                        })

                    },


                    afterrender: function (grid) {
                        gridInstance = grid;

                        // The searchfield sets this to true on init
                        grid.getStore().setRemoteFilter(false);
                        grid.getStore().load();

                        console.log("AFTER RENDER");


                    }

                }
            }
        );


        mappingPanel.callParent();
        // pimcore.plugin.pim.MappingPanel.superclass.initComponent.call(this);
    },

    showSettingsWindow: function (record) {
        var settings = record.get('settings'),
            format = settings.format;

        var fields = [{
            xtype: 'checkbox',
            name: 'keyMapping',
            fieldLabel: 'Schlüsselattribut',
            checked: settings.keyMapping
        },
        {
            xtype: 'checkbox',
            name: 'writeProtected',
            fieldLabel: 'nicht überschreiben, wenn bereits gefüllt',
            readOnly: record.get('attributeKey') === 'fullpath',
            checked: format.writeProtected
        }];

        switch (record.get('type')) {
            case 'numeric':
                fields.push({
                    xtype: 'textfield',
                    name: 'groupingSeparator',
                    fieldLabel: 'Tausendertrennzeichen',
                    value: format.groupingSeparator
                }, {
                    xtype: 'textfield',
                    name: 'decimalSeparator',
                    fieldLabel: 'Dezimaltrennzeichen',
                    value: format.decimalSeparator
                });

                break;

            case 'date':
            case 'datetime':
                fields.push({
                    xtype: 'textfield',
                    name: 'dateFormat',
                    fieldLabel: 'Datumsformat',
                    value: format.dateFormat
                });

                break;

            case 'multiselect':
                fields.push({
                    xtype: 'textfield',
                    name: 'separator',
                    fieldLabel: 'Trennzeichen',
                    value: format.separator
                });

                break;

            case 'image':
                fields.push({
                    xtype: 'checkbox',
                    name: 'overwrite',
                    fieldLabel: 'Bild(er) überschreiben',
                    checked: format.overwrite
                });

                break;

            case 'hotspotimage':
                fields.push({
                    xtype: 'checkbox',
                    name: 'overwrite',
                    fieldLabel: 'Bild(er) überschreiben',
                    checked: format.overwrite
                });

                break;

            case 'multihref':
            case 'manyToManyRelation':
                fields.push({
                    xtype: 'checkbox',
                    name: 'overwrite',
                    fieldLabel: 'Bild(er) überschreiben',
                    checked: format.overwrite
                });
                fields.push({
                    xtype: 'checkbox',
                    name: 'purgeitems',
                    fieldLabel: 'Inhalt vor Import leeren',
                    checked: format.purgeitems
                });

                break;


            case 'fieldcollections':
                fields.push({
                    xtype: 'checkbox',
                    name: 'editOnly',
                    fieldLabel: 'Nur editieren',
                    checked: format.editOnly
                });

            case 'objects':
            case 'objectsMetadata':
            case 'multihrefMetadata':
            case 'manyToManyObjectRelation':
            case 'advancedManyToManyObjectRelation':
            case 'advancedManyToManyRelation':
                fields.push({
                    xtype: 'checkbox',
                    name: 'purgeitems',
                    fieldLabel: 'Inhalt vor Import leeren',
                    checked: format.purgeitems
                });

                break;
        }

        fields.push({
            xtype: 'textarea',
            name: 'calculation',
            fieldLabel: 'Formel',
            // width: 375,
            height: 150,
            value: settings.calculation
        });

        var settingsForm = Ext.create('Ext.form.Panel', {
            anchor: '100%',
            border: false,
            padding: 15,
            defaults: {
                width: 600,
                labelWidth: 150
            },

            layout: {
                type: 'vbox',
                align: 'streched'
            },
            items: fields
        });

        var settingsWindow = new Ext.Window({
            layout: 'anchor',
            title: t('pim.settingspanel.caption'),
            width: 700,
            height: 450,
            closable: true,
            resizable: false,
            draggable: true,
            modal: true,
            items: [settingsForm],
            bbar: [
                {
                    xtype: 'button',
                    text: t('pim.mapping.savebutton'),
                    handler: function (button) {
                        var formPanel = settingsForm;
                        var form = formPanel.getForm();
                        var values = form.getFieldValues();

                        var settings = {
                            keyMapping: values.keyMapping === true,
                            calculation: values.calculation
                        };

                        if (format) {
                            settings.format = {};
                            if (format.decimalSeparator) {
                                settings.format.decimalSeparator = values.decimalSeparator;
                            }
                            if (format.groupingSeparator) {
                                settings.format.groupingSeparator = values.groupingSeparator;
                            }
                            if (format.separator) {
                                settings.format.separator = values.separator;
                            }
                            if (format.dateFormat) {
                                settings.format.dateFormat = values.dateFormat;
                            }

                            settings.format.overwrite = values.overwrite === true;
                            settings.format.writeProtected = values.writeProtected === true;
                            settings.format.purgeitems = values.purgeitems === true;
                            settings.format.editOnly = values.editOnly === true;
                        }

                        record.set('settings', settings);
                        formPanel.findParentByType('window').close();
                    }
                }
            ]
        });

        settingsWindow.show();
    }
});
