# Monitoring Tools

The package is developed in a very short period of time and pressure of time and still needs to be optimized and expanded.

This package contains a standardized Format for monitoring checks.

If this package is installed, then you can define information such as
deployed Git Version, Application Status and the environment.

The GIT Version is automatically detected if git is installed on the target system.

## Installation
    composer require LCP/monitoring-tools

## Usage
Use the Class MonitoringTools to implement this feature in your application.

1. Create your MonitoringController and create the basic health check model.

2. Create the basic health check Model
    ```php
    $healthCheckRequest = new Lifestyle\Monitoring\Model\HealthCheckRequest;
   
    $healthCheckRequest
       ->setEnvironment($kernel->getEnvironment()); 
    ```
   You can specify a custom status via setStatus().    
   The environment can be set from the kernel of the application,
   that the target system can be checked if the correct environment and config is loaded

3. Return the serialized JSON content in your controller. An example below.
   ```php
   return new Response (MonitoringTools::provide_health_check($model), 200);
   ```

## Defaults
* Status -> OK
* Git Version -> Command to determine otherwise false
* Environment -> false

## DO
* Name your Controller MonitoringController
* Name your default route "health_check"
* Set the environment from your application kernel

## DO NOT
* manipulate the format of the JSON
* name your route other than "health_check"
* name your Controller other than "MonitoringController"

## This still needs to be done
* Determine if GIT is installed on the target system
* extend health check format to allow custom application states
* define further features (ex. database testing, configuration, etc)
* cleanups