<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\Monitoring\Mapper;

use Lifestyle\Monitoring\Model\HealthCheck;
use Lifestyle\Monitoring\Model\HealthCheckRequest;
use Lifestyle\Monitoring\MonitoringTools;
use Lifestyle\Monitoring\Util\GitUtil;

/**
 * Class HealthCheckMapper
 * @package Lifestyle\Monitoring\Mapper
 */
class HealthCheckMapper
{
    /**
     * @param HealthCheckRequest $healthCheckRequest
     * @return HealthCheck
     */
    public function map(HealthCheckRequest $healthCheckRequest)
    {
        $healthCheck = (new HealthCheck())
            // Setting the defaults. Will be overrided below if a healthCheckRequest is provided and filled
            ->setStatus('OK')
            ->setVersion(GitUtil::gitVersionTag())
            ->setEnvironment(false);

        if (isset($healthCheckRequest) && !empty($healthCheckRequest->getStatus())) {
            $healthCheck->setStatus($healthCheckRequest->getStatus());
        }

        if (isset($healthCheckRequest) && !empty($healthCheckRequest->getVersion())) {
            $healthCheck->setVersion($healthCheckRequest->getVersion());
        }

        if (isset($healthCheckRequest) && !empty($healthCheckRequest->getEnvironment())) {
            $healthCheck->setEnvironment($healthCheckRequest->getEnvironment());
        }

        return $healthCheck;
    }
}