<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\Monitoring\Model;

/**
 * Class HealthCheckRequest
 * @package Lifestyle\Monitoring\Model
 */
class HealthCheckRequest
{
    /**
     * @var string
     */
    private $status;

    /**
     * @var string
     */
    private $version;

    /**
     * @var string
     */
    private $environment;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return HealthCheckRequest
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * @param string $version
     * @return HealthCheckRequest
     */
    public function setVersion($version)
    {
        $this->version = $version;
        return $this;
    }

    /**
     * @return string
     */
    public function getEnvironment()
    {
        return $this->environment;
    }

    /**
     * @param string $environment
     * @return HealthCheckRequest
     */
    public function setEnvironment($environment)
    {
        $this->environment = $environment;
        return $this;
    }
}