<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\Monitoring;

use Lifestyle\Monitoring\Mapper\HealthCheckMapper;
use Lifestyle\Monitoring\Model\HealthCheck;
use Lifestyle\Monitoring\Model\HealthCheckRequest;

/**
 * Class MonitoringTools
 * @package Lifestyle\Monitoring
 */
final class MonitoringTools
{
    private function __construct()
    {
        // ToDo: So MonitoringTools cannot be instantiated
    }

    /**
     * This method provides basic information about an instance.
     * Hereby a basic status, which environment and what version is deployed.
     * IMPORTANT: Git must be installed on the target system.
     *
     * @param HealthCheckRequest|null $healthCheckRequest
     * @return HealthCheck
     */
    public static function provideHealthCheck($healthCheckRequest = null)
    {
        //TODO: maybe use factory method and private constructors
        $data = new HealthCheck();
        $mapper = new HealthCheckMapper();

        $healthCheck = $mapper->map($healthCheckRequest);

        $data
            ->setStatus($healthCheck->getStatus())
            ->setEnvironment($healthCheck->getEnvironment())
            ->setVersion($healthCheck->getVersion());

        return $data->asJson();
    }
}