<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\Monitoring\Mapper;

use Lifestyle\Monitoring\Model\HealthCheckResponse;
use Lifestyle\Monitoring\Model\HealthCheckRequest;
use Lifestyle\Monitoring\Util\CommandChecker;
use Lifestyle\Monitoring\Util\EnvironmentDetector;
use Lifestyle\Monitoring\Util\GitDetector;

/**
 * Class HealthCheckMapper
 * @package Lifestyle\Monitoring\Mapper
 */
class HealthCheckMapper
{
    /**
     * @param HealthCheckRequest $healthCheckRequest
     * @return HealthCheckResponse
     */
    public function map(HealthCheckRequest $healthCheckRequest)
    {
        $healthCheck = (new HealthCheckResponse())
            // Setting the defaults. Will be overridden below if a healthCheckRequest is provided and filled
            ->setStatus('OK')
            ->setEnvironment(false);

        if ($healthCheckRequest->hasVersion()) {
            $healthCheck->setVersion($healthCheckRequest->getVersion());
        } elseif (CommandChecker::commandExist('git')) {
            $healthCheck->setVersion(GitDetector::gitVersionTag());
        }

        if ($healthCheckRequest->hasEnvironment()) {
            $healthCheck->setEnvironment($healthCheckRequest->getEnvironment());
        } else {
            $variableName = ($healthCheckRequest->hasEnvironmentVariableName()) ? $healthCheckRequest->getEnvironmentVariableName() : null;
            $healthCheck->setEnvironment(EnvironmentDetector::provideEnvironment($variableName));
        }

        if ($healthCheckRequest->hasStatus()) {
            $healthCheck->setStatus($healthCheckRequest->getStatus());
        }

        return $healthCheck;
    }
}
