<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\Monitoring\Model;

/**
 * Class HealthCheckRequest
 * @package Lifestyle\Monitoring\Model
 */
class HealthCheckRequest
{
    /**
     * @var string|null
     */
    private $status;

    /**
     * @var string|null
     */
    private $version;

    /**
     * @var string|null
     */
    private $environment;

    /**
     * @var string|null
     */
    private $environmentVariableName;

    /**
     * @return bool
     */
    public function hasStatus()
    {
        return !empty($this->status);
    }

    /**
     * @return bool
     */
    public function hasVersion()
    {
        return !empty($this->version);
    }

    /**
     * @return bool
     */
    public function hasEnvironment()
    {
        return !empty($this->environment);
    }
    /**
     * @return bool
     */
    public function hasEnvironmentVariableName()
    {
        return !empty($this->environmentVariableName);
    }

    /**
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string|null $status
     * @return HealthCheckRequest
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }

    /**
     * @param string|null $version
     * @return HealthCheckRequest
     */
    public function setVersion($version)
    {
        $this->version = $version;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEnvironment()
    {
        return $this->environment;
    }

    /**
     * @param string|null $environment
     * @return HealthCheckRequest
     */
    public function setEnvironment($environment)
    {
        $this->environment = $environment;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEnvironmentVariableName()
    {
        return $this->environmentVariableName;
    }

    /**
     * @param string|null $environmentVariableName
     * @return HealthCheckRequest
     */
    public function setEnvironmentVariableName($environmentVariableName)
    {
        $this->environmentVariableName = $environmentVariableName;
        return $this;
    }
}
