# Lifestyle Monitoring Tools

This package contains a standardized format for easy monitoring checks.

If this package is installed, then you can define information such as the
git tag of the deployed application, application status and the environment.

The git tag is **ONLY** detected automatically if git is installed on the target system.

The tools will generate an output in the below format.
`{"status":"OK","applicationName":"monitoring-tools","version":"0.5","environment":"dev"}`

## Installation

    composer require LCP/monitoring-tools

## Usage

Use the Class MonitoringTools to implement this feature in your application.    
Depending on your application you will need to create the MonitoringController
and/or define the route "health_check".

You can find an example in the `example.php` file.

### Automatic Detection of the application environment

With the following line you can let the monitoring tools automatically scan the environment.    

```php
MonitoringTools::provideHealthCheckAsJson();
```
Which environment variables are checked can be found in the constant of the `EnvironmentDetector` class.
Priority of the automatic detection currently is

    APP_ENV > SYMFONY_ENV > APPLICATION_ENV

#### Override the environment within the application

If you want to ensure providing the correct environment from the application kernel,
then you can create your own request. 
With this you are overriding the automatic detection mechanism.

```php
$healthCheckRequest = new Lifestyle\Monitoring\Model\HealthCheckRequest();

$healthCheckRequest
    ->setEnvironment($kernel->getEnvironment()); 
   
MonitoringTools::provideHealthCheckAsObject($healthCheckRequest);
```

#### Using a custom Environment variable

In some cases you would like to use a custom environment variable. 
For example your environment information is stored in the variable `FOO=BAR`.
The automatic mechanism does not know this variable. 
See below on how to use this.

```php
$healthCheckRequest = new Lifestyle\Monitoring\Model\HealthCheckRequest();

$healthCheckRequest
   ->setEnvironmentVariableName('FOO'); 
   
MonitoringTools::provideHealthCheckAsObject($healthCheckRequest);
``` 

## Defaults

* Status -> OK
* Git Version -> Automatic mechanism or null
* Environment -> Automatic mechanism or null

## DO

* Name your Controller **MonitoringController** or **MonitoringCommand** if you use commands
* Name your route "**health_check**"
* If necessary override the environment from your application kernel
* Always contact your DevOp to add the Health Check from the application in the monitoring 

## DO NOT

* manipulate the format of the JSON
* name your route other than "health_check"
* name your Controller other than "MonitoringController"
* use the environment variable for other fields other than the actual environment (ex. dev/test/prod)
