<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

require_once 'vendor/autoload.php';

use Lifestyle\Monitoring\Model\HealthCheckRequest;
use Lifestyle\Monitoring\MonitoringTools;

// Lowest requirement
$healthCheck = MonitoringTools::provideHealthCheckAsJson();
// string(88) "{"status":"OK","applicationName":"monitoring-tools","version":"1.1.0","environment":"dev"}"


// Populating everything.

$request = new HealthCheckRequest();
$request
    ->setStatus('OK')
    ->setApplicationName('monitoring-tools')
    ->setEnvironment('prod')                              // Actually should not be necessary.
    ->setEnvironmentVariableName('APP_ENV')     // Only if it should be gotten dynamic from the env vars.
    ->setVersion('1.0.5');                                   // If version is not set, then it will be determined by the git tag

$healthCheck = MonitoringTools::provideHealthCheckAsJson($request);
// {"status":"OK","applicationName":"monitoring-tools","version":"1.0.5","environment":"prod"}"