<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\Monitoring;

use Lifestyle\Monitoring\Mapper\HealthCheckMapper;
use Lifestyle\Monitoring\Model\HealthCheckRequest;
use Lifestyle\Monitoring\Model\HealthCheckResponse;

/**
 * Class MonitoringTools
 * @package Lifestyle\Monitoring
 */
final class MonitoringTools
{
    /**
     * This method provides basic information about an instance.
     * Hereby a basic status, which environment and what version is deployed.
     *
     * @param HealthCheckRequest|null $healthCheckRequest
     * @return HealthCheckResponse
     */
    public static function provideHealthCheckAsObject($healthCheckRequest = null)
    {
        $mapper = new HealthCheckMapper();

        if (null === $healthCheckRequest) {
            $healthCheckRequest = new HealthCheckRequest();
        }

        return $mapper->map($healthCheckRequest);
    }

    /**
     * You can also get the object directly as a json string.
     *
     * @param HealthCheckRequest|null $healthCheckRequest
     * @return string
     */
    public static function provideHealthCheckAsJson($healthCheckRequest = null)
    {
        $healthCheckResponse = static::provideHealthCheckAsObject($healthCheckRequest);

        return json_encode($healthCheckResponse);
    }
}
