<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\Test\Monitoring;

use Lifestyle\Monitoring\Model\HealthCheckRequest;
use Lifestyle\Monitoring\MonitoringTools;
use Lifestyle\Monitoring\Util\GitDetector;
use PHPUnit\Framework\TestCase;

/**
 * Class MonitoringTools
 * @package Lifestyle\Test\Monitoring
 */
class MonitoringToolsTest extends TestCase
{
    public function test_monitoring_tools_with_empty_request()
    {
        $response = MonitoringTools::provideHealthCheckAsObject();

        self::assertEquals(GitDetector::getTag(), $response->getVersion());
        self::assertEquals('OK', $response->getStatus());

        self::assertEquals('dev', $response->getEnvironment());
    }

    public function test_monitoring_tools_with_filled_request()
    {
        $request = (new HealthCheckRequest())
            ->setStatus('YES')
            ->setEnvironment('Mars')
            ->setVersion(1337.5);

        $response = MonitoringTools::provideHealthCheckAsObject($request);

        self::assertEquals(1337.5, $response->getVersion());
        self::assertEquals('YES', $response->getStatus());
        self::assertEquals('Mars', $response->getEnvironment());
    }

    public function test_monitoring_tools_on_json_serialize()
    {
        $response = MonitoringTools::provideHealthCheckAsJson();

        $responseAsArray = json_decode($response, true);
        self::assertEquals('OK', $responseAsArray['status']);
        self::assertEquals(GitDetector::getTag(), $responseAsArray['version']);
        self::assertEquals('dev', $responseAsArray['environment']);
    }
}
