<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\Monitoring\Util;

/**
 * Class EnvironmentDetector
 * @package Lifestyle\Monitoring\Mapper
 */
final class EnvironmentDetector
{
    /**
     * These are all environment variables which are used for automatic detecting the environment.
     * The order of the array is the order in which the variables are checked.
     */
    const ENVIRONMENT_VARIABLES = [
        'APP_ENV',
        'SYMFONY_ENV',
        'APPLICATION_ENV'
    ];

    /**
     * @param null $variableName Name of the environment variable to check for in $_SERVER and $_ENV
     * @return string|null
     */
    public static function provideEnvironment($variableName = null)
    {
        if (null !== $variableName && (isset($_SERVER[$variableName]) || isset($_ENV[$variableName]))) {
            return $_SERVER[$variableName] = $_ENV[$variableName] = ($_SERVER[$variableName]) ? $_SERVER[$variableName] : $_ENV[$variableName];
        }

        foreach (static::ENVIRONMENT_VARIABLES as $name) {
            if (isset($_SERVER[$name]) || isset($_ENV[$name])) {
                return $_SERVER[$name] = $_ENV[$name] = isset($_SERVER[$name]) ? $_SERVER[$name] : $_ENV[$name];
            }
        }

        return 'dev';
    }
}
