<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

/**
 * Class ApiGetObjectDeepLink_IndexController
 */
class ApiGetObjectDeepLink_IndexController extends \Pimcore\Controller\Action
{

    /**
     * reachable via http://your.domain/plugin/ApiGetObjectDeepLink/index/index
     */
    public function indexAction()
    {

        try {

            $this->disableViewAutoRender();
            $this->disableLayout();

            $key = filter_input(INPUT_GET, 'key');

            if (empty($key)) {

                $this->_helper->redirector->gotoUrl('/plugin/ApiGetObjectDeepLink/error/keyisnotset');
            }

            $objectListing = new \Pimcore\Model\Object\Listing();

            $objectListing->setCondition('o_key = ?', $key);
            $objectListing->load();

            if ($objectListing->count() !== 1) {

                $this->_helper->redirector->gotoUrl('/plugin/ApiGetObjectDeepLink/error/objectnotfound');
            }

            $object = $objectListing->current();

            $query = 'object_' . $object->getId() . '_object';

            $this->_helper->redirector->gotoUrl('/admin/login/deeplink?' . $query);

        } catch (Exception $e) {

            echo $e->getMessage();
        }
    }
}
