<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author    Franz Weisflug
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Publikat\Pimcore\ApiGetObjectDeepLinkBundle\Controller;

use Exception;
use \Pimcore\Model\Object\Listing;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/**
 * Class IndexController
 *
 * @Route("/plugin/ApiGetObjectDeepLink", name="api_get_object_deep_link")
 *
 * @package Publikat\Pimcore\ApiGetObjectDeepLinkBundle\Controller
 */
class IndexController extends AbstractController
{
    /**
     * @Route("/index/index", name="_index")
     */
    public function import(Request $request)
    {
        try {
            $key = $request->get('key');

            if (empty($key)) {
                return $this->render(
                    '@ApiGetObjectDeepLink/error.html.twig',
                    ['message' => 'Key is not set!']
                );
            }

            $objectListing = new Listing();
            $objectListing->setCondition('o_key = ?', strtoupper($key));
            $objectListing->addConditionParam('o_key = ?', strtolower($key), 'OR');
            $objectListing->load();

            if ($objectListing->count() !== 1) {
                return $this->render(
                    '@ApiGetObjectDeepLink/error.html.twig',
                    ['message' => 'Object not found!']
                );
            }

            $object = $objectListing->current();
            $query = 'object_' . $object->getId() . '_object';
            $url = $this->generateUrl('pimcore_admin_login_deeplink') . '?' . $query;

            return $this->redirect($url);
        } catch (Exception $e) {
            return $this->render(
                '@ApiGetObjectDeepLink/error.html.twig',
                ['message' => $e->getMessage()]
            );
        }
    }
}
