<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\AssignProductImagesBundle\EventListener;

use Lifestyle\Pimcore\AssignProductImagesBundle\Configuration\PictureTypesList;
use Lifestyle\Pimcore\AssignProductImagesBundle\Events\AssignProductImagesEvents;
use Lifestyle\Pimcore\AssignProductImagesBundle\Model\AssetInfo;
use Lifestyle\Pimcore\AssignProductImagesBundle\Services\AssetTypeHandler\AssetTypeHandlerFactory;
use Pimcore\Event\Model\AssetEvent;
use Pimcore\Model\Asset\Image;
use Pimcore\Model\Asset\Unknown;
use Symfony\Component\EventDispatcher\EventDispatcher;

/**
 * Class DeleteAssetListener
 *
 * @package Lifestyle\Pimcore\AssignProductImagesBundle\EventListener
 */
class DeleteAssetListener
{
    /**
     * @var AssetTypeHandlerFactory
     */
    protected $assetTypeHandlerFactory;
    /**
     * @var EventDispatcher
     */
    protected $eventDispatcher;
    /**
     * @var PictureTypesList
     */
    protected $pictureTypesList;

    /**
     * AddAssetListener constructor.
     *
     * @param AssetTypeHandlerFactory $assetTypeHandlerFactory
     * @param EventDispatcher         $eventDispatcher
     * @param PictureTypesList        $pictureTypesList
     */
    public function __construct(
        AssetTypeHandlerFactory $assetTypeHandlerFactory,
        EventDispatcher $eventDispatcher,
        PictureTypesList $pictureTypesList
    ) {
        $this->assetTypeHandlerFactory = $assetTypeHandlerFactory;
        $this->eventDispatcher = $eventDispatcher;
        $this->pictureTypesList = $pictureTypesList;
    }

    /**
     * @param AssetEvent $assetEvent
     */
    public function onAfterAssetDeleted(AssetEvent $assetEvent)
    {
        $assetInfo = new AssetInfo($assetEvent->getAsset());

        if ($this->pictureTypesList->hasPictureType($assetInfo->getPictureType())
            && ($assetEvent->getAsset() instanceof Image || $assetEvent->getAsset() instanceof Unknown)
        ) {
            $pictureTypeConfig = $this->pictureTypesList->getPictureTypeConfig($assetInfo->getPictureType());

            $success = $this->assetTypeHandlerFactory->getByType($pictureTypeConfig->getType())->processDelete(
                $assetEvent,
                $pictureTypeConfig
            );

            if (true === $success) {
                // dispatch post unassign event
                $this->eventDispatcher->dispatch(AssignProductImagesEvents::POST_UNASSIGN, $assetEvent);
            }
        }
    }
}
