<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\AssignProductImagesBundle\Configuration;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class PictureTypeConfig
 *
 * @package Lifestyle\Pimcore\AssignProductImagesBundle\Configuration
 */
class PictureTypeConfig
{
    /**
     * @var string
     */
    protected $name;
    /**
     * @var string
     */
    protected $type;
    /**
     * @var string
     */
    protected $objectName;
    /**
     * @var string
     */
    protected $propertyName;
    /**
     * @var ArrayCollection
     */
    protected $metaData;

    /**
     * PictureTypeConfig constructor.
     *
     * @param array $configuration
     */
    public function __construct(string $name, array $configuration)
    {
        $this->name = $name;
        $this->type = $configuration['type'];
        $this->objectName = $configuration['object'];
        $this->propertyName = $configuration['property'];
        $this->metaData = new ArrayCollection($configuration['metadata'] ?? []);
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getObjectName(): string
    {
        return $this->objectName;
    }

    /**
     * @return string
     */
    public function getPropertyName(): string
    {
        return $this->propertyName;
    }

    /**
     * @return ArrayCollection
     */
    public function getMetaData(): ArrayCollection
    {
        return $this->metaData;
    }
}
